/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.auth;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.logging.EventLog;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import com.hivemq.util.Bytes;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.nio.ByteBuffer;
import javax.inject.Singleton;

@Singleton
public class MqttAuthSender {
    @NotNull
    private final EventLog eventLog;

    @Inject
    public MqttAuthSender(@NotNull EventLog eventLog) {
        this.eventLog = eventLog;
    }

    @NotNull
    public ChannelFuture sendAuth(@NotNull Channel channel, @Nullable ByteBuffer authData, @NotNull Mqtt5AuthReasonCode reasonCode, @NotNull Mqtt5UserProperties userProperties, @Nullable String reasonString) {
        AUTH auth = new AUTH(ClientConnectionContext.of(channel).getAuthMethod(), Bytes.fromReadOnlyBuffer(authData), reasonCode, userProperties, reasonString);
        this.logAuth(channel, reasonCode, false);
        return channel.writeAndFlush((Object)auth);
    }

    public void logAuth(@NotNull Channel channel, @NotNull Mqtt5AuthReasonCode reasonCode, boolean received) {
        this.eventLog.clientAuthentication(channel, reasonCode, received);
    }
}

