/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.connack;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extensions.events.OnAuthFailedEvent;
import com.hivemq.extensions.events.OnServerDisconnectEvent;
import com.hivemq.logging.EventLog;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.connack.CONNACKBuilder;
import com.hivemq.mqtt.message.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.util.Bytes;
import com.hivemq.util.ThreadPreConditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttConnackerImpl
implements MqttConnacker {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(MqttConnackerImpl.class);
    private final boolean connackWithReasonCode;
    private final boolean connackWithReasonString;
    @NotNull
    private final EventLog eventLog;

    @Inject
    public MqttConnackerImpl(@NotNull EventLog eventLog) {
        this.eventLog = eventLog;
        this.connackWithReasonCode = InternalConfigurations.CONNACK_WITH_REASON_CODE_ENABLED.get();
        this.connackWithReasonString = InternalConfigurations.CONNACK_WITH_REASON_STRING_ENABLED.get();
    }

    @Override
    @NotNull
    public ChannelFuture connackSuccess(@NotNull ChannelHandlerContext ctx, @NotNull CONNACK connack, @NotNull CONNECT connect) {
        Preconditions.checkNotNull((Object)ctx, (Object)"ChannelHandlerContext must never be null");
        Preconditions.checkNotNull((Object)connack, (Object)"CONNACK must never be null");
        Preconditions.checkNotNull((Object)connect, (Object)"CONNECT must never be null");
        Preconditions.checkArgument((connack.getReasonCode() == Mqtt5ConnAckReasonCode.SUCCESS ? 1 : 0) != 0, (Object)"Error is no success");
        ThreadPreConditions.inNettyChildEventloop();
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)connack);
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                this.eventLog.clientConnected(future.channel(), connect.isCleanStart());
            }
        }));
        return channelFuture;
    }

    @Override
    public void connackError(@NotNull Channel channel, @Nullable String logMessage, @Nullable String eventLogMessage, @Nullable Mqtt5ConnAckReasonCode reasonCode, @Nullable String reasonString) {
        this.connackError(channel, logMessage, eventLogMessage, reasonCode, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, false);
    }

    @Override
    public void connackError(@NotNull Channel channel, @Nullable String logMessage, @Nullable String eventLogMessage, @Nullable Mqtt5ConnAckReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, boolean isAuthentication) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel must never be null");
        Preconditions.checkArgument((reasonCode != Mqtt5ConnAckReasonCode.SUCCESS ? 1 : 0) != 0, (Object)"Success is no error");
        ThreadPreConditions.inNettyChildEventloop();
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        ClientState oldClientState = clientConnectionContext.getClientState();
        clientConnectionContext.proposeClientState(ClientState.DISCONNECTING);
        ProtocolVersion protocolVersion = clientConnectionContext.getProtocolVersion();
        this.logConnack(channel, logMessage, eventLogMessage);
        if (protocolVersion == null) {
            channel.close();
            return;
        }
        this.fireEvents(clientConnectionContext, oldClientState, reasonCode, reasonString, userProperties, isAuthentication);
        if (protocolVersion == ProtocolVersion.MQTTv3_1 || protocolVersion == ProtocolVersion.MQTTv3_1_1) {
            this.connackError3(clientConnectionContext, this.connackWithReasonCode, reasonCode);
        } else {
            this.connackError5(clientConnectionContext, this.connackWithReasonCode, this.connackWithReasonString, reasonCode, reasonString, userProperties);
        }
    }

    private void logConnack(@NotNull Channel channel, @Nullable String logMessage, @Nullable String eventLogMessage) {
        if (log.isDebugEnabled() && logMessage != null && !logMessage.isEmpty()) {
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
            log.debug(logMessage, (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
        }
        if (eventLogMessage != null && !eventLogMessage.isEmpty()) {
            this.eventLog.clientWasDisconnected(channel, eventLogMessage);
        }
    }

    private void connackError3(@NotNull ClientConnectionContext clientConnectionContext, boolean withReasonCode, @Nullable Mqtt5ConnAckReasonCode reasonCode) {
        Mqtt3ConnAckReturnCode returnCode = MqttConnackerImpl.transformReasonCode(reasonCode);
        clientConnectionContext.proposeClientState(ClientState.CONNECT_FAILED);
        if (returnCode != null && withReasonCode) {
            CONNACK connack = CONNACK.builder().withMqtt3ReturnCode(returnCode).build();
            clientConnectionContext.getChannel().writeAndFlush((Object)connack).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            clientConnectionContext.getChannel().close();
        }
    }

    private void connackError5(@NotNull ClientConnectionContext clientConnectionContext, boolean withReasonCode, boolean withReasonString, @Nullable Mqtt5ConnAckReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
        if (withReasonCode) {
            Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null for Mqtt 5");
            if (!withReasonString) {
                reasonString = null;
            }
        } else {
            reasonCode = null;
            reasonString = null;
        }
        clientConnectionContext.proposeClientState(ClientState.CONNECT_FAILED);
        if (reasonCode != null) {
            CONNACKBuilder connackBuilder = CONNACK.builder().withReasonCode(reasonCode).withReasonString(reasonString).withUserProperties(userProperties);
            String authMethod = clientConnectionContext.getAuthMethod();
            if (authMethod != null) {
                connackBuilder.withAuthMethod(authMethod);
                ByteBuffer authData = clientConnectionContext.getAuthData();
                if (authData != null) {
                    clientConnectionContext.setAuthData(null);
                    connackBuilder.withAuthData(Bytes.fromReadOnlyBuffer(authData));
                }
            }
            clientConnectionContext.getChannel().writeAndFlush((Object)connackBuilder.build()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            clientConnectionContext.getChannel().close();
        }
    }

    private void fireEvents(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ClientState oldClientState, @Nullable Mqtt5ConnAckReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, boolean isAuthentication) {
        if (oldClientState != ClientState.CONNECTING) {
            DisconnectedReasonCode disconnectedReasonCode = reasonCode == null ? null : reasonCode.toDisconnectedReasonCode();
            clientConnectionContext.getChannel().pipeline().fireUserEventTriggered(isAuthentication ? new OnAuthFailedEvent(disconnectedReasonCode, reasonString, userProperties) : new OnServerDisconnectEvent(disconnectedReasonCode, reasonString, userProperties));
        }
    }

    @Nullable
    private static Mqtt3ConnAckReturnCode transformReasonCode(@Nullable Mqtt5ConnAckReasonCode reasonCode) {
        if (reasonCode == null) {
            return null;
        }
        switch (reasonCode) {
            case UNSPECIFIED_ERROR: 
            case MALFORMED_PACKET: 
            case PROTOCOL_ERROR: 
            case IMPLEMENTATION_SPECIFIC_ERROR: {
                return null;
            }
        }
        return Mqtt3ConnAckReturnCode.fromReasonCode(reasonCode);
    }
}

