/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.connect;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.PINGREQ;
import com.hivemq.mqtt.message.suback.SUBACK;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import com.hivemq.mqtt.message.unsubscribe.UNSUBSCRIBE;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;

public class SubscribeMessageBarrier
extends ChannelDuplexHandler {
    @NotNull
    private final Queue<Message> messageQueue = new LinkedList<Message>();

    public static void addToPipeline(@NotNull ChannelHandlerContext ctx) {
        if (!ctx.pipeline().names().contains("mqtt_subscribe_message_barrier")) {
            SubscribeMessageBarrier subscribeMessageBarrier = new SubscribeMessageBarrier();
            ctx.pipeline().addAfter("mqtt_message_encoder", "mqtt_subscribe_message_barrier", (ChannelHandler)subscribeMessageBarrier);
        }
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        ctx.channel().config().setAutoRead(false);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (msg instanceof Message && !(msg instanceof PINGREQ)) {
            this.messageQueue.add((Message)msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void write(final @NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) throws Exception {
        if (msg instanceof SUBACK || msg instanceof UNSUBACK) {
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(@NotNull ChannelFuture future) {
                    boolean allMessagesReleased;
                    if (future.isSuccess() && (allMessagesReleased = this.releaseQueuedMessages(ctx))) {
                        ctx.channel().config().setAutoRead(true);
                        ctx.pipeline().remove((ChannelHandler)SubscribeMessageBarrier.this);
                    }
                }

                private boolean releaseQueuedMessages(@NotNull ChannelHandlerContext ctx2) {
                    while (SubscribeMessageBarrier.this.messageQueue.size() > 0) {
                        Message message = SubscribeMessageBarrier.this.messageQueue.poll();
                        ctx2.fireChannelRead((Object)message);
                        if (!(message instanceof SUBSCRIBE) && !(message instanceof UNSUBSCRIBE)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        super.write(ctx, msg, promise);
    }

    @VisibleForTesting
    @NotNull
    Collection<Message> getQueue() {
        return Collections.unmodifiableCollection(this.messageQueue);
    }
}

