/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.subscribe.retained;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.subscribe.retained.RetainedMessagesSender;
import com.hivemq.mqtt.message.pool.exception.NoMessageIdAvailableException;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendRetainedMessageListenerAndScheduleNext
implements FutureCallback<Void> {
    private static final Logger log = LoggerFactory.getLogger(SendRetainedMessageListenerAndScheduleNext.class);
    @NotNull
    private final Topic subscription;
    @NotNull
    private final Queue<String> topics;
    @NotNull
    private final Channel channel;
    @NotNull
    private final RetainedMessagesSender retainedMessagesSender;
    private final int batchSizeMax;

    SendRetainedMessageListenerAndScheduleNext(@NotNull Topic subscription, @NotNull Queue<String> topics, @NotNull Channel channel, @NotNull RetainedMessagesSender retainedMessagesSender, int batchSizeMax) {
        Preconditions.checkNotNull((Object)subscription, (Object)"Subscription must not be null");
        Preconditions.checkNotNull(topics, (Object)"Topics must not be null");
        Preconditions.checkNotNull((Object)channel, (Object)"Channel must not be null");
        Preconditions.checkNotNull((Object)retainedMessagesSender, (Object)"RetainedMessagesSender must not be null");
        this.subscription = subscription;
        this.topics = topics;
        this.channel = channel;
        this.retainedMessagesSender = retainedMessagesSender;
        this.batchSizeMax = batchSizeMax;
    }

    public void onSuccess(Void result) {
        if (!this.channel.isActive()) {
            return;
        }
        this.send();
    }

    private void send() {
        int remainingTopics = this.topics.size();
        if (remainingTopics == 0) {
            return;
        }
        int batchSize = Math.min(remainingTopics, this.batchSizeMax);
        Topic[] topicBatch = new Topic[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            String nextTopic = this.topics.poll();
            topicBatch[i] = new Topic(nextTopic, this.subscription.getQoS(), this.subscription.isNoLocal(), this.subscription.isRetainAsPublished(), this.subscription.getRetainHandling(), this.subscription.getSubscriptionIdentifier());
        }
        ListenableFuture<Void> sentFuture = this.retainedMessagesSender.writeRetainedMessages(this.channel, topicBatch);
        Futures.addCallback(sentFuture, (FutureCallback)new SendRetainedMessageListenerAndScheduleNext(this.subscription, this.topics, this.channel, this.retainedMessagesSender, this.batchSizeMax), (Executor)this.channel.eventLoop());
    }

    public void onFailure(@NotNull Throwable throwable) {
        if (Exceptions.isConnectionClosedException(throwable)) {
            return;
        }
        if (throwable instanceof NoMessageIdAvailableException) {
            if (this.channel.isActive()) {
                this.channel.eventLoop().schedule(() -> {
                    if (log.isTraceEnabled()) {
                        log.trace("Retrying retained message for client '{}' on topic '{}'.", (Object)ClientConnection.of(this.channel).getClientId(), (Object)this.subscription.getTopic());
                    }
                    this.send();
                }, 1L, TimeUnit.SECONDS);
            }
        } else {
            Exceptions.rethrowError("Unable to send retained message for subscription " + this.subscription.getTopic() + " to client " + ClientConnection.of(this.channel).getClientId() + ".", throwable);
            this.channel.disconnect();
        }
    }
}

