/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.subscribe.retained;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.subscribe.retained.RetainedMessagesSender;
import com.hivemq.mqtt.handler.subscribe.retained.SendRetainedMessageListenerAndScheduleNext;
import com.hivemq.mqtt.handler.subscribe.retained.SendRetainedMessageResultListener;
import com.hivemq.mqtt.message.mqtt5.Mqtt5RetainHandling;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.persistence.clientsession.callback.SubscriptionResult;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

public class SendRetainedMessagesListener
implements ChannelFutureListener {
    @NotNull
    private final RetainedMessagePersistence retainedMessagePersistence;
    @NotNull
    private final RetainedMessagesSender retainedMessagesSender;
    @NotNull
    private final List<SubscriptionResult> subscriptions;
    @NotNull
    private final Set<Topic> ignoredTopics;

    public SendRetainedMessagesListener(@NotNull List<SubscriptionResult> subscriptions, @NotNull Set<Topic> ignoredTopics, @NotNull RetainedMessagePersistence retainedMessagePersistence, @NotNull RetainedMessagesSender retainedMessagesSender) {
        Preconditions.checkNotNull(subscriptions, (Object)"Subscriptions must not be null");
        Preconditions.checkNotNull(ignoredTopics, (Object)"ignoredTopics must not be null");
        this.subscriptions = subscriptions;
        this.ignoredTopics = ignoredTopics;
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.retainedMessagesSender = retainedMessagesSender;
    }

    public void operationComplete(@Nullable ChannelFuture future) throws Exception {
        if (future != null && future.isSuccess()) {
            Channel channel = future.channel();
            if (channel == null || !channel.isActive()) {
                return;
            }
            List<Topic> topicsWithWildcards = this.sendExactMatches(channel);
            if (!topicsWithWildcards.isEmpty()) {
                this.sendMatchingWildcardSubscriptions(topicsWithWildcards, channel);
            }
        }
    }

    @NotNull
    private List<Topic> sendExactMatches(@NotNull Channel channel) {
        ArrayList<Topic> topicsWithWildcards = new ArrayList<Topic>(this.subscriptions.size());
        for (SubscriptionResult subscription : this.subscriptions) {
            Topic subscriptionTopic;
            if (subscription == null || (subscriptionTopic = subscription.getTopic()).getRetainHandling() == Mqtt5RetainHandling.DO_NOT_SEND || subscriptionTopic.getRetainHandling() == Mqtt5RetainHandling.SEND_IF_SUBSCRIPTION_DOES_NOT_EXIST && subscription.subscriptionAlreadyExisted() || subscription.getShareName() != null || this.ignoredTopics.contains(subscriptionTopic)) continue;
            String topic = subscriptionTopic.getTopic();
            if (topic.contains("#") || topic.contains("+")) {
                topicsWithWildcards.add(subscriptionTopic);
                continue;
            }
            ListenableFuture<Void> writeFuture = this.retainedMessagesSender.writeRetainedMessages(channel, subscriptionTopic);
            Futures.addCallback(writeFuture, (FutureCallback)new SendRetainedMessageResultListener(channel, subscriptionTopic, this.retainedMessagesSender), (Executor)channel.eventLoop());
        }
        return topicsWithWildcards;
    }

    private void sendMatchingWildcardSubscriptions(@NotNull List<Topic> topicsWithWildcards, @NotNull Channel channel) {
        for (Topic subscribedTopic : topicsWithWildcards) {
            ListenableFuture<Set<String>> future = this.retainedMessagePersistence.getWithWildcards(subscribedTopic.getTopic());
            Futures.addCallback(future, (FutureCallback)new RetainedMessagesHandleWildcardsCallback(subscribedTopic, channel, this.retainedMessagesSender), (Executor)channel.eventLoop());
        }
    }

    static class RetainedMessagesHandleWildcardsCallback
    implements FutureCallback<Set<String>> {
        static final int CONCURRENT_MESSAGES = 25;
        @NotNull
        private final Topic subscription;
        @NotNull
        private final Channel channel;
        @NotNull
        private final RetainedMessagesSender retainedMessagesSender;

        RetainedMessagesHandleWildcardsCallback(@NotNull Topic subscription, @NotNull Channel channel, @NotNull RetainedMessagesSender retainedMessagesSender) {
            this.subscription = subscription;
            this.channel = channel;
            this.retainedMessagesSender = retainedMessagesSender;
        }

        public void onSuccess(@Nullable Set<String> retainedMessageTopics) {
            if (retainedMessageTopics == null || retainedMessageTopics.size() == 0) {
                return;
            }
            ConcurrentLinkedQueue<String> topics = new ConcurrentLinkedQueue<String>(retainedMessageTopics);
            Integer clientReceiveMaximum = ClientConnection.of(this.channel).getClientReceiveMaximum();
            int concurrentMessages = clientReceiveMaximum == null ? 25 : Math.min(clientReceiveMaximum, 25);
            concurrentMessages = Math.min(concurrentMessages, retainedMessageTopics.size());
            Topic[] topicBatch = new Topic[concurrentMessages];
            for (int i = 0; i < concurrentMessages; ++i) {
                String nextTopic = (String)topics.poll();
                topicBatch[i] = new Topic(nextTopic, this.subscription.getQoS(), this.subscription.isNoLocal(), this.subscription.isRetainAsPublished(), this.subscription.getRetainHandling(), this.subscription.getSubscriptionIdentifier());
            }
            ListenableFuture<Void> sentFuture = this.retainedMessagesSender.writeRetainedMessages(this.channel, topicBatch);
            Futures.addCallback(sentFuture, (FutureCallback)new SendRetainedMessageListenerAndScheduleNext(this.subscription, topics, this.channel, this.retainedMessagesSender, concurrentMessages), (Executor)this.channel.eventLoop());
        }

        public void onFailure(@NotNull Throwable throwable) {
            ClientConnection clientConnection = ClientConnection.of(this.channel);
            Exceptions.rethrowError("Unable to send retained messages on topic " + this.subscription.getTopic() + " to client " + clientConnection.getClientId() + ".", throwable);
            this.channel.disconnect();
        }
    }
}

