/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.mqtt5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import io.netty.buffer.ByteBuf;

public class Mqtt5UserProperties {
    public static final Mqtt5UserProperties NO_USER_PROPERTIES = new Mqtt5UserProperties((ImmutableList<MqttUserProperty>)ImmutableList.of());
    @NotNull
    private final ImmutableList<MqttUserProperty> userProperties;
    private int encodedLength = -1;

    @NotNull
    public static Mqtt5UserProperties of(MqttUserProperty ... userProperties) {
        Preconditions.checkNotNull((Object)userProperties);
        return Mqtt5UserProperties.of((ImmutableList<MqttUserProperty>)ImmutableList.copyOf((Object[])userProperties));
    }

    @NotNull
    public static Mqtt5UserProperties of(@NotNull ImmutableList<MqttUserProperty> userProperties) {
        return userProperties.isEmpty() ? NO_USER_PROPERTIES : new Mqtt5UserProperties(userProperties);
    }

    @NotNull
    public static Mqtt5UserProperties build(@Nullable ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder) {
        return userPropertiesBuilder == null ? NO_USER_PROPERTIES : Mqtt5UserProperties.of((ImmutableList<MqttUserProperty>)userPropertiesBuilder.build());
    }

    private Mqtt5UserProperties(@NotNull ImmutableList<MqttUserProperty> userProperties) {
        this.userProperties = userProperties;
    }

    @NotNull
    public ImmutableList<MqttUserProperty> asList() {
        return this.userProperties;
    }

    public void encode(@NotNull ByteBuf out) {
        for (int i = 0; i < this.userProperties.size(); ++i) {
            ((MqttUserProperty)this.userProperties.get(i)).encode(out);
        }
    }

    public int encodedLength() {
        if (this.encodedLength == -1) {
            this.encodedLength = this.calculateEncodedLength();
        }
        return this.encodedLength;
    }

    private int calculateEncodedLength() {
        int encodedLength = 0;
        for (int i = 0; i < this.userProperties.size(); ++i) {
            encodedLength += ((MqttUserProperty)this.userProperties.get(i)).encodedLength();
        }
        return encodedLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt5UserProperties)) {
            return false;
        }
        Mqtt5UserProperties that = (Mqtt5UserProperties)o;
        return this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return this.userProperties.hashCode();
    }

    @NotNull
    public String toString() {
        return this.userProperties.toString();
    }
}

