/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;
import java.util.EnumSet;

public enum Mqtt5DisconnectReasonCode implements Mqtt5ReasonCode
{
    NORMAL_DISCONNECTION(0),
    DISCONNECT_WITH_WILL_MESSAGE(4),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    MALFORMED_PACKET(MqttCommonReasonCode.MALFORMED_PACKET),
    PROTOCOL_ERROR(MqttCommonReasonCode.PROTOCOL_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    SERVER_BUSY(MqttCommonReasonCode.SERVER_BUSY),
    SERVER_SHUTTING_DOWN(139),
    BAD_AUTHENTICATION_METHOD(MqttCommonReasonCode.BAD_AUTHENTICATION_METHOD),
    KEEP_ALIVE_TIMEOUT(141),
    SESSION_TAKEN_OVER(142),
    TOPIC_FILTER_INVALID(MqttCommonReasonCode.TOPIC_FILTER_INVALID),
    TOPIC_NAME_INVALID(MqttCommonReasonCode.TOPIC_NAME_INVALID),
    RECEIVE_MAXIMUM_EXCEEDED(147),
    TOPIC_ALIAS_INVALID(148),
    PACKET_TOO_LARGE(MqttCommonReasonCode.PACKET_TOO_LARGE),
    MESSAGE_RATE_TOO_HIGH(150),
    QUOTA_EXCEEDED(MqttCommonReasonCode.QUOTA_EXCEEDED),
    ADMINISTRATIVE_ACTION(152),
    PAYLOAD_FORMAT_INVALID(MqttCommonReasonCode.PAYLOAD_FORMAT_INVALID),
    RETAIN_NOT_SUPPORTED(MqttCommonReasonCode.RETAIN_NOT_SUPPORTED),
    QOS_NOT_SUPPORTED(MqttCommonReasonCode.QOS_NOT_SUPPORTED),
    USE_ANOTHER_SERVER(MqttCommonReasonCode.USE_ANOTHER_SERVER),
    SERVER_MOVED(MqttCommonReasonCode.SERVER_MOVED),
    SHARED_SUBSCRIPTION_NOT_SUPPORTED(MqttCommonReasonCode.SHARED_SUBSCRIPTION_NOT_SUPPORTED),
    CONNECTION_RATE_EXCEEDED(MqttCommonReasonCode.CONNECTION_RATE_EXCEEDED),
    MAXIMUM_CONNECT_TIME(160),
    SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(MqttCommonReasonCode.SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED),
    WILDCARD_SUBSCRIPTION_NOT_SUPPORTED(MqttCommonReasonCode.WILDCARD_SUBSCRIPTION_NOT_SUPPORTED);

    private final int code;
    @NotNull
    private final DisconnectReasonCode disconnectReasonCode;
    @NotNull
    private final DisconnectedReasonCode disconnectedReasonCode;
    private static final int ERROR_CODE_MIN;
    private static final int ERROR_CODE_MAX;
    @NotNull
    private static final Mqtt5DisconnectReasonCode[] ERROR_CODE_LOOKUP;
    @NotNull
    private static final @NotNull Mqtt5DisconnectReasonCode @NotNull [] DISCONNECT_LOOKUP;
    private static final @Nullable Mqtt5DisconnectReasonCode @NotNull [] DISCONNECTED_LOOKUP;
    @NotNull
    private static final EnumSet<Mqtt5DisconnectReasonCode> BY_CLIENT;

    private Mqtt5DisconnectReasonCode(int code) {
        this.code = code;
        this.disconnectReasonCode = DisconnectReasonCode.valueOf((String)this.name());
        this.disconnectedReasonCode = DisconnectedReasonCode.valueOf((String)this.name());
    }

    private Mqtt5DisconnectReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public DisconnectReasonCode toDisconnectReasonCode() {
        return this.disconnectReasonCode;
    }

    @NotNull
    public DisconnectedReasonCode toDisconnectedReasonCode() {
        return this.disconnectedReasonCode;
    }

    @Nullable
    public static Mqtt5DisconnectReasonCode fromCode(int code) {
        if (code == Mqtt5DisconnectReasonCode.NORMAL_DISCONNECTION.code) {
            return NORMAL_DISCONNECTION;
        }
        if (code == Mqtt5DisconnectReasonCode.DISCONNECT_WITH_WILL_MESSAGE.code) {
            return DISCONNECT_WITH_WILL_MESSAGE;
        }
        if (code < ERROR_CODE_MIN || code > ERROR_CODE_MAX) {
            return null;
        }
        return ERROR_CODE_LOOKUP[code - ERROR_CODE_MIN];
    }

    @NotNull
    public static Mqtt5DisconnectReasonCode from(@NotNull DisconnectReasonCode reasonCode) {
        return DISCONNECT_LOOKUP[reasonCode.ordinal()];
    }

    @Nullable
    public static Mqtt5DisconnectReasonCode from(@NotNull DisconnectedReasonCode reasonCode) {
        return DISCONNECTED_LOOKUP[reasonCode.ordinal()];
    }

    @Override
    public boolean canBeSentByServer() {
        return this != DISCONNECT_WITH_WILL_MESSAGE;
    }

    @Override
    public boolean canBeSentByClient() {
        return BY_CLIENT.contains(this);
    }

    static {
        ERROR_CODE_MIN = Mqtt5DisconnectReasonCode.UNSPECIFIED_ERROR.code;
        ERROR_CODE_MAX = Mqtt5DisconnectReasonCode.WILDCARD_SUBSCRIPTION_NOT_SUPPORTED.code;
        ERROR_CODE_LOOKUP = new Mqtt5DisconnectReasonCode[ERROR_CODE_MAX - ERROR_CODE_MIN + 1];
        DISCONNECT_LOOKUP = new Mqtt5DisconnectReasonCode[DisconnectReasonCode.values().length];
        DISCONNECTED_LOOKUP = new Mqtt5DisconnectReasonCode[DisconnectedReasonCode.values().length];
        for (Mqtt5DisconnectReasonCode reasonCode : Mqtt5DisconnectReasonCode.values()) {
            if (reasonCode != NORMAL_DISCONNECTION && reasonCode != DISCONNECT_WITH_WILL_MESSAGE) {
                Mqtt5DisconnectReasonCode.ERROR_CODE_LOOKUP[reasonCode.code - Mqtt5DisconnectReasonCode.ERROR_CODE_MIN] = reasonCode;
            }
            Mqtt5DisconnectReasonCode.DISCONNECT_LOOKUP[reasonCode.disconnectReasonCode.ordinal()] = reasonCode;
            Mqtt5DisconnectReasonCode.DISCONNECTED_LOOKUP[reasonCode.disconnectedReasonCode.ordinal()] = reasonCode;
        }
        BY_CLIENT = EnumSet.of(NORMAL_DISCONNECTION, new Mqtt5DisconnectReasonCode[]{DISCONNECT_WITH_WILL_MESSAGE, UNSPECIFIED_ERROR, PROTOCOL_ERROR, IMPLEMENTATION_SPECIFIC_ERROR, TOPIC_FILTER_INVALID, TOPIC_NAME_INVALID, RECEIVE_MAXIMUM_EXCEEDED, TOPIC_ALIAS_INVALID, PACKET_TOO_LARGE, MESSAGE_RATE_TOO_HIGH, QUOTA_EXCEEDED, ADMINISTRATIVE_ACTION});
    }
}

