/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.pubrel.PubrelReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5PubRelReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    PACKET_IDENTIFIER_NOT_FOUND(MqttCommonReasonCode.PACKET_IDENTIFIER_NOT_FOUND);

    private final int code;
    @NotNull
    private final PubrelReasonCode pubrelReasonCode;
    @NotNull
    private static final @NotNull Mqtt5PubRelReasonCode @NotNull [] PUBREL_LOOKUP;

    private Mqtt5PubRelReasonCode(int code) {
        this.code = code;
        this.pubrelReasonCode = PubrelReasonCode.valueOf((String)this.name());
    }

    private Mqtt5PubRelReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public PubrelReasonCode toPubrelReasonCode() {
        return this.pubrelReasonCode;
    }

    @Nullable
    public static Mqtt5PubRelReasonCode fromCode(int code) {
        if (code == Mqtt5PubRelReasonCode.SUCCESS.code) {
            return SUCCESS;
        }
        if (code == Mqtt5PubRelReasonCode.PACKET_IDENTIFIER_NOT_FOUND.code) {
            return PACKET_IDENTIFIER_NOT_FOUND;
        }
        return null;
    }

    @NotNull
    public static Mqtt5PubRelReasonCode from(@NotNull PubrelReasonCode reasonCode) {
        return PUBREL_LOOKUP[reasonCode.ordinal()];
    }

    @Override
    public boolean canBeSentByClient() {
        return true;
    }

    static {
        PUBREL_LOOKUP = new Mqtt5PubRelReasonCode[PubrelReasonCode.values().length];
        Mqtt5PubRelReasonCode[] mqtt5PubRelReasonCodeArray = Mqtt5PubRelReasonCode.values();
        int n = mqtt5PubRelReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5PubRelReasonCode reasonCode;
            Mqtt5PubRelReasonCode.PUBREL_LOOKUP[reasonCode.pubrelReasonCode.ordinal()] = reasonCode = mqtt5PubRelReasonCodeArray[i];
        }
    }
}

