/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic.tree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.hivemq.annotations.ReadOnly;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.topic.SubscriberWithQoS;
import com.hivemq.mqtt.topic.tree.SubscriptionCounters;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MatchingNodeSubscriptions {
    @Nullable
    @Nullable SubscriberWithQoS @Nullable [] nonSharedSubscribersArray;
    @Nullable
    Map<String, SubscriberWithQoS> nonSharedSubscribersMap;
    @NotNull
    Map<String, SubscriptionGroup> sharedSubscribersMap = Map.of();

    MatchingNodeSubscriptions() {
    }

    public boolean addSubscriber(@NotNull SubscriberWithQoS subscriberToAdd, @NotNull String topicFilter, @NotNull SubscriptionCounters counters, int subscriberMapCreationThreshold) {
        SubscriptionInfoPresenceStatus subscriptionInfoPresenceStatus = this.storeSubscriberInStructures(subscriberToAdd, topicFilter, subscriberMapCreationThreshold);
        if (subscriptionInfoPresenceStatus == null) {
            counters.getSubscriptionCounter().inc();
        }
        return subscriptionInfoPresenceStatus != null;
    }

    public void removeSubscriber(@NotNull String subscriber, @Nullable String sharedName, @Nullable String topicFilter, @NotNull SubscriptionCounters counters) {
        SubscriptionInfoRemovalStatus subscriptionInfoRemovalStatus = this.removeSubscriberFromStructures(subscriber, sharedName, topicFilter);
        if (subscriptionInfoRemovalStatus != null) {
            counters.getSubscriptionCounter().dec();
        }
    }

    public void populateWithSubscriberNamesUsingFilter(@NotNull Predicate<SubscriberWithQoS> itemFilter, @NotNull ImmutableSet.Builder<String> subscribers) {
        this.populateUsingFilter(itemFilter, null, subscribers);
    }

    public void populateWithSubscribersUsingFilter(@NotNull Predicate<SubscriberWithQoS> itemFilter, @NotNull ImmutableSet.Builder<SubscriberWithQoS> subscribers) {
        this.populateUsingFilter(itemFilter, subscribers, null);
    }

    private void populateUsingFilter(@NotNull Predicate<SubscriberWithQoS> itemFilter, @Nullable ImmutableSet.Builder<SubscriberWithQoS> subscribersBuilder, @Nullable ImmutableSet.Builder<String> subscriberNamesBuilder) {
        assert (subscribersBuilder != null || subscriberNamesBuilder != null);
        this.getAllSubscriptionsStream().filter(itemFilter).forEach(subscriber -> {
            if (subscribersBuilder != null) {
                subscribersBuilder.add(subscriber);
            } else {
                subscriberNamesBuilder.add((Object)subscriber.getSubscriber());
            }
        });
    }

    @ReadOnly
    public int getSubscriberCount() {
        int nonSharedSubscribersCount = this.nonSharedSubscribersMap != null ? this.nonSharedSubscribersMap.size() : MatchingNodeSubscriptions.countArraySize(this.nonSharedSubscribersArray);
        return nonSharedSubscribersCount + this.sharedSubscribersMap.size();
    }

    @ReadOnly
    @NotNull
    public Stream<SubscriberWithQoS> getSharedSubscriptionsStream() {
        return this.sharedSubscribersMap.values().stream().flatMap(subscriptionGroup -> subscriptionGroup.getSubscriptionsInfos().stream());
    }

    @ReadOnly
    @Nullable
    public Stream<SubscriberWithQoS> getNonSharedSubscriptionsStream() {
        if (this.nonSharedSubscribersMap == null && this.nonSharedSubscribersArray == null) {
            return null;
        }
        if (this.nonSharedSubscribersMap == null) {
            return Stream.of(this.nonSharedSubscribersArray).filter(Objects::nonNull);
        }
        return this.nonSharedSubscribersMap.values().stream();
    }

    @ReadOnly
    @NotNull
    private Stream<SubscriberWithQoS> getAllSubscriptionsStream() {
        Stream<SubscriberWithQoS> sharedSubscriptionStream = this.getSharedSubscriptionsStream();
        Stream<SubscriberWithQoS> nonSharedSubscriptionStream = this.getNonSharedSubscriptionsStream();
        if (nonSharedSubscriptionStream == null) {
            return sharedSubscriptionStream;
        }
        return Stream.concat(sharedSubscriptionStream, nonSharedSubscriptionStream);
    }

    @ReadOnly
    @VisibleForTesting
    @NotNull
    public Set<SubscriberWithQoS> getSubscribers() {
        return this.getAllSubscriptionsStream().collect(Collectors.toSet());
    }

    @ReadOnly
    public boolean isEmpty() {
        return !(this.nonSharedSubscribersMap != null && !this.nonSharedSubscribersMap.isEmpty() || this.nonSharedSubscribersArray != null && !MatchingNodeSubscriptions.isEmptyArray(this.nonSharedSubscribersArray) || !this.sharedSubscribersMap.isEmpty());
    }

    @NotNull
    private static String sharedSubscriptionKey(@NotNull String sharedName, @NotNull String topicFilter) {
        return sharedName + "/" + topicFilter;
    }

    @Nullable
    private SubscriptionInfoPresenceStatus storeSubscriberInStructures(@NotNull SubscriberWithQoS subscriberToAdd, @NotNull String topicFilter, int subscriberMapCreationThreshold) {
        int exactSubscribersCount;
        if (subscriberToAdd.isSharedSubscription() && subscriberToAdd.getSharedName() != null) {
            SubscriberWithQoS prev;
            if (this.sharedSubscribersMap.isEmpty()) {
                this.sharedSubscribersMap = new HashMap<String, SubscriptionGroup>(subscriberMapCreationThreshold);
            }
            return (prev = this.sharedSubscribersMap.computeIfAbsent(MatchingNodeSubscriptions.sharedSubscriptionKey(subscriberToAdd.getSharedName(), topicFilter), key -> new SubscriptionGroup()).put(subscriberToAdd)) == null ? null : new SubscriptionInfoPresenceStatus(prev.equals(subscriberToAdd));
        }
        int n = exactSubscribersCount = this.nonSharedSubscribersMap != null ? this.nonSharedSubscribersMap.values().size() : MatchingNodeSubscriptions.countArraySize(this.nonSharedSubscribersArray);
        if (this.nonSharedSubscribersMap == null && exactSubscribersCount > subscriberMapCreationThreshold) {
            this.nonSharedSubscribersMap = new HashMap<String, SubscriberWithQoS>(subscriberMapCreationThreshold + 1);
            if (this.nonSharedSubscribersArray != null) {
                for (SubscriberWithQoS subscriber : this.nonSharedSubscribersArray) {
                    if (subscriber == null) continue;
                    this.nonSharedSubscribersMap.put(subscriber.getSubscriber(), subscriber);
                }
                this.nonSharedSubscribersArray = null;
            }
        }
        if (this.nonSharedSubscribersMap != null) {
            SubscriberWithQoS prev = this.nonSharedSubscribersMap.put(subscriberToAdd.getSubscriber(), subscriberToAdd);
            return prev == null ? null : new SubscriptionInfoPresenceStatus(prev.equals(subscriberToAdd));
        }
        if (this.nonSharedSubscribersArray == null) {
            this.nonSharedSubscribersArray = new SubscriberWithQoS[]{subscriberToAdd};
            return null;
        }
        for (int i = 0; i < this.nonSharedSubscribersArray.length; ++i) {
            if (this.nonSharedSubscribersArray[i] == null || !subscriberToAdd.getSubscriber().equals(this.nonSharedSubscribersArray[i].getSubscriber())) continue;
            SubscriptionInfoPresenceStatus subscriptionInfoPresenceStatus = new SubscriptionInfoPresenceStatus(this.nonSharedSubscribersArray[i].equals(subscriberToAdd));
            this.nonSharedSubscribersArray[i] = subscriberToAdd;
            return subscriptionInfoPresenceStatus;
        }
        int emptySlotIndex = Arrays.asList(this.nonSharedSubscribersArray).indexOf(null);
        if (emptySlotIndex >= 0) {
            this.nonSharedSubscribersArray[emptySlotIndex] = subscriberToAdd;
        } else {
            SubscriberWithQoS[] newArray = new SubscriberWithQoS[this.nonSharedSubscribersArray.length + 1];
            System.arraycopy(this.nonSharedSubscribersArray, 0, newArray, 0, this.nonSharedSubscribersArray.length);
            newArray[this.nonSharedSubscribersArray.length] = subscriberToAdd;
            this.nonSharedSubscribersArray = newArray;
        }
        return null;
    }

    @Nullable
    private SubscriptionInfoRemovalStatus removeSubscriberFromStructures(@NotNull String subscriber, @Nullable String sharedName, @Nullable String topicFilter) {
        SubscriberWithQoS remove;
        block6: {
            block5: {
                remove = null;
                if (sharedName == null || topicFilter == null) break block5;
                String sharedSubscriptionKey = MatchingNodeSubscriptions.sharedSubscriptionKey(sharedName, topicFilter);
                SubscriptionGroup group = this.sharedSubscribersMap.get(sharedSubscriptionKey);
                if (group == null) break block6;
                remove = group.remove(subscriber);
                if (group.size() == 0) {
                    this.sharedSubscribersMap.remove(sharedSubscriptionKey);
                }
                break block6;
            }
            if (this.nonSharedSubscribersMap != null) {
                remove = this.nonSharedSubscribersMap.remove(subscriber);
            } else if (this.nonSharedSubscribersArray != null) {
                for (int i = 0; i < this.nonSharedSubscribersArray.length; ++i) {
                    SubscriberWithQoS arrayEntry = this.nonSharedSubscribersArray[i];
                    if (arrayEntry == null || !subscriber.equals(arrayEntry.getSubscriber()) || !subscriber.equals(arrayEntry.getSubscriber())) continue;
                    this.nonSharedSubscribersArray[i] = null;
                    remove = arrayEntry;
                    break;
                }
            }
        }
        return remove == null ? null : new SubscriptionInfoRemovalStatus(remove.isSharedSubscription());
    }

    private static boolean isEmptyArray(@Nullable @Nullable Object @Nullable [] array) {
        if (array == null) {
            return true;
        }
        for (Object object : array) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    private static int countArraySize(@Nullable @Nullable Object @Nullable [] array) {
        if (array == null) {
            return 0;
        }
        int count = 0;
        for (Object object : array) {
            if (object == null) continue;
            ++count;
        }
        return count;
    }

    private static class SubscriptionInfoRemovalStatus {
        public final boolean wasSharedSubscription;

        SubscriptionInfoRemovalStatus(boolean wasSharedSubscription) {
            this.wasSharedSubscription = wasSharedSubscription;
        }
    }

    private static class SubscriptionInfoPresenceStatus {
        public final boolean subscriptionInfoSame;

        SubscriptionInfoPresenceStatus(boolean subscriptionInfoSame) {
            this.subscriptionInfoSame = subscriptionInfoSame;
        }
    }

    private static class SubscriptionGroup {
        @NotNull
        private final Map<String, SubscriberWithQoS> subscriptions = new HashMap<String, SubscriberWithQoS>();

        private SubscriptionGroup() {
        }

        @Nullable
        SubscriberWithQoS put(@NotNull SubscriberWithQoS subscription) {
            return this.subscriptions.put(subscription.getSubscriber(), subscription);
        }

        @Nullable
        SubscriberWithQoS remove(@NotNull String subscriber) {
            return this.subscriptions.remove(subscriber);
        }

        @NotNull
        Collection<SubscriberWithQoS> getSubscriptionsInfos() {
            return this.subscriptions.values();
        }

        int size() {
            return this.subscriptions.size();
        }
    }
}

