/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientsession;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.Sizable;
import com.hivemq.persistence.clientsession.ClientSessionWill;
import com.hivemq.util.ObjectMemoryEstimation;

public class ClientSession
implements Sizable {
    @Nullable
    private final Long queueLimit;
    private boolean connected;
    private long sessionExpiryIntervalSec;
    private int inMemorySize = -1;
    @Nullable
    private ClientSessionWill willPublish;

    public ClientSession(boolean connected, long sessionExpiryInterval) {
        this(connected, sessionExpiryInterval, null, null);
    }

    public ClientSession(boolean connected, long sessionExpiryIntervalSec, @Nullable ClientSessionWill willPublish, @Nullable Long queueLimit) {
        Preconditions.checkArgument((sessionExpiryIntervalSec >= 0L ? 1 : 0) != 0, (Object)"Session expiry interval must never be less than zero");
        this.connected = connected;
        this.sessionExpiryIntervalSec = sessionExpiryIntervalSec;
        this.willPublish = willPublish;
        this.queueLimit = queueLimit;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public long getSessionExpiryIntervalSec() {
        return this.sessionExpiryIntervalSec;
    }

    public void setSessionExpiryIntervalSec(long sessionExpiryIntervalSec) {
        this.sessionExpiryIntervalSec = sessionExpiryIntervalSec;
    }

    @Nullable
    public ClientSessionWill getWillPublish() {
        return this.willPublish;
    }

    public void setWillPublish(@Nullable ClientSessionWill willPublish) {
        this.willPublish = willPublish;
    }

    @Nullable
    public Long getQueueLimit() {
        return this.queueLimit;
    }

    @NotNull
    public ClientSession deepCopy() {
        return new ClientSession(this.connected, this.sessionExpiryIntervalSec, this.willPublish != null ? this.willPublish.deepCopy() : null, this.queueLimit);
    }

    @NotNull
    public ClientSession copyWithoutWill() {
        return new ClientSession(this.connected, this.sessionExpiryIntervalSec, null, this.queueLimit);
    }

    @Override
    public int getEstimatedSize() {
        if (this.inMemorySize != -1) {
            return this.inMemorySize;
        }
        int size = ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.booleanSize();
        size += ObjectMemoryEstimation.longSize();
        size += ObjectMemoryEstimation.objectRefSize();
        if (this.willPublish != null) {
            size += this.willPublish.getEstimatedSize();
        }
        if (this.queueLimit != null) {
            size += ObjectMemoryEstimation.longSize();
        }
        this.inMemorySize = size;
        return this.inMemorySize;
    }

    public boolean isExpired(long timeSinceDisconnectMsec) {
        if (this.connected) {
            return false;
        }
        return timeSinceDisconnectMsec / 1000L >= this.sessionExpiryIntervalSec;
    }
}

