/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus.clientsession;

import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.mqtt5.PropertiesSerializationUtil;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.clientsession.ClientSessionWill;
import com.hivemq.util.Bytes;
import java.nio.charset.StandardCharsets;

public class ClientSessionPersistenceSerializer {
    private static final int NO_WILL_MARKER = -1;
    private static final byte CLIENT_CONNECTED_BIT = 0;
    private static final byte QUEUE_SIZE_PRESENT_BIT = 1;

    public byte[] serializeKey(String clientId) {
        return clientId.getBytes(StandardCharsets.UTF_8);
    }

    public String deserializeKey(byte[] bytes) {
        return new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
    }

    public byte[] serializeValue(ClientSession clientSession, long timestamp) {
        ClientSessionWill willPublish = clientSession.getWillPublish();
        int willLength = 1;
        byte[] topic = null;
        int topicLength = 0;
        byte[] responseTopic = null;
        int responseTopicLength = 0;
        byte[] hivemqId = null;
        int hivemqIdLength = 0;
        byte[] correlationData = null;
        int correlationDataLength = 0;
        int payloadFormatIndicator = -1;
        byte[] contentType = null;
        int contentTypeLength = 0;
        if (willPublish != null) {
            topic = willPublish.getTopic().getBytes();
            topicLength = topic.length;
            hivemqId = willPublish.getHivemqId().getBytes();
            hivemqIdLength = hivemqId.length;
            willLength += 30 + topicLength + 4 + hivemqIdLength + PropertiesSerializationUtil.encodedSize(willPublish.getUserProperties());
            responseTopic = willPublish.getResponseTopic() != null ? willPublish.getResponseTopic().getBytes() : null;
            responseTopicLength = responseTopic != null ? responseTopic.length : 0;
            willLength += responseTopicLength + 4;
            correlationData = willPublish.getCorrelationData();
            correlationDataLength = correlationData != null ? correlationData.length : 0;
            willLength += correlationDataLength + 4;
            contentType = willPublish.getContentType() != null ? willPublish.getContentType().getBytes() : null;
            contentTypeLength = contentType != null ? contentType.length : 0;
            willLength += contentTypeLength + 4;
            payloadFormatIndicator = (byte)(willPublish.getPayloadFormatIndicator() != null ? willPublish.getPayloadFormatIndicator().getCode() : -1);
        }
        int queueLimitLength = clientSession.getQueueLimit() != null ? 8 : 0;
        byte[] bytes = new byte[17 + willLength + queueLimitLength];
        int cursor = 0;
        Bytes.copyLongToByteArray(timestamp, bytes, 0);
        Bytes.copyLongToByteArray(clientSession.getSessionExpiryIntervalSec(), bytes, cursor += 8);
        byte flags = 0;
        flags = Bytes.setBit(flags, 0, clientSession.isConnected());
        bytes[cursor += 8] = flags = Bytes.setBit(flags, 1, clientSession.getQueueLimit() != null);
        ++cursor;
        if (clientSession.getQueueLimit() != null) {
            Bytes.copyLongToByteArray(clientSession.getQueueLimit(), bytes, cursor);
            cursor += 8;
        }
        if (willLength == 1) {
            bytes[cursor] = -1;
            ++cursor;
        } else {
            bytes[cursor] = (byte)willPublish.getQos().getQosNumber();
            Bytes.copyLongToByteArray(willPublish.getPublishId(), bytes, ++cursor);
            Bytes.copyLongToByteArray(willPublish.getDelayInterval(), bytes, cursor += 8);
            Bytes.copyLongToByteArray(willPublish.getMessageExpiryInterval(), bytes, cursor += 8);
            bytes[cursor += 8] = payloadFormatIndicator;
            bytes[++cursor] = (byte)(willPublish.isRetain() ? 1 : 0);
            Bytes.copyIntToByteArray(topicLength, bytes, ++cursor);
            System.arraycopy(topic, 0, bytes, cursor += 4, topicLength);
            Bytes.copyIntToByteArray(hivemqIdLength, bytes, cursor += topicLength);
            System.arraycopy(hivemqId, 0, bytes, cursor += 4, hivemqIdLength);
            Bytes.copyIntToByteArray(responseTopicLength, bytes, cursor += hivemqIdLength);
            cursor += 4;
            if (responseTopicLength > 0) {
                System.arraycopy(responseTopic, 0, bytes, cursor, responseTopicLength);
                cursor += responseTopicLength;
            }
            Bytes.copyIntToByteArray(correlationDataLength, bytes, cursor);
            cursor += 4;
            if (correlationDataLength > 0) {
                System.arraycopy(correlationData, 0, bytes, cursor, correlationDataLength);
                cursor += correlationDataLength;
            }
            Bytes.copyIntToByteArray(contentTypeLength, bytes, cursor);
            cursor += 4;
            if (contentTypeLength > 0) {
                System.arraycopy(contentType, 0, bytes, cursor, contentTypeLength);
                cursor += contentTypeLength;
            }
            PropertiesSerializationUtil.write(willPublish.getUserProperties(), bytes, cursor);
        }
        return bytes;
    }

    @NotNull
    public ClientSession deserializeValue(byte[] bytes) {
        int cursor = 8;
        long timeToLive = Bytes.readLong(bytes, cursor);
        byte flags = bytes[cursor += 8];
        boolean connected = Bytes.isBitSet(flags, 0);
        ++cursor;
        Long queueLimit = null;
        if (Bytes.isBitSet(flags, 1)) {
            queueLimit = Bytes.readLong(bytes, cursor);
            cursor += 8;
        }
        byte willQos = bytes[cursor];
        ++cursor;
        ClientSessionWill sessionWill = null;
        if (willQos != -1) {
            MqttWillPublish.Mqtt5Builder willBuilder = new MqttWillPublish.Mqtt5Builder();
            willBuilder.withQos(QoS.valueOf(willQos));
            long publishId = Bytes.readLong(bytes, cursor);
            willBuilder.withDelayInterval(Bytes.readLong(bytes, cursor += 8));
            willBuilder.withMessageExpiryInterval(Bytes.readLong(bytes, cursor += 8));
            byte payloadFormatCode = bytes[cursor += 8];
            willBuilder.withPayloadFormatIndicator(payloadFormatCode != -1 ? Mqtt5PayloadFormatIndicator.fromCode(payloadFormatCode) : null);
            willBuilder.withRetain(bytes[++cursor] == 1);
            int topicLength = Bytes.readInt(bytes, ++cursor);
            cursor += 4;
            if (topicLength > 0) {
                willBuilder.withTopic(new String(bytes, cursor, topicLength));
                cursor += topicLength;
            }
            int hivemqIdLength = Bytes.readInt(bytes, cursor);
            cursor += 4;
            if (topicLength > 0) {
                willBuilder.withHivemqId(new String(bytes, cursor, hivemqIdLength));
                cursor += hivemqIdLength;
            }
            int responseTopicLength = Bytes.readInt(bytes, cursor);
            cursor += 4;
            if (responseTopicLength > 0) {
                willBuilder.withResponseTopic(new String(bytes, cursor, responseTopicLength));
                cursor += responseTopicLength;
            }
            int correlationDataLength = Bytes.readInt(bytes, cursor);
            cursor += 4;
            if (correlationDataLength != 0) {
                byte[] correlationData = new byte[correlationDataLength];
                System.arraycopy(bytes, cursor, correlationData, 0, correlationDataLength);
                willBuilder.withCorrelationData(correlationData);
                cursor += correlationDataLength;
            }
            int contentTypeLength = Bytes.readInt(bytes, cursor);
            cursor += 4;
            if (contentTypeLength != 0) {
                willBuilder.withContentType(new String(bytes, cursor, contentTypeLength, StandardCharsets.UTF_8));
                cursor += contentTypeLength;
            }
            willBuilder.withUserProperties(PropertiesSerializationUtil.read(bytes, cursor));
            sessionWill = new ClientSessionWill(willBuilder.build(), publishId);
        }
        return new ClientSession(connected, timeToLive, sessionWill, queueLimit);
    }

    @NotNull
    public ClientSession deserializeValueWithoutWill(byte[] bytes) {
        int cursor = 8;
        long timeToLive = Bytes.readLong(bytes, cursor);
        byte flags = bytes[cursor += 8];
        boolean connected = Bytes.isBitSet(flags, 0);
        ++cursor;
        Long queueLimit = null;
        if (Bytes.isBitSet(flags, 1)) {
            queueLimit = Bytes.readLong(bytes, cursor);
            cursor += 8;
        }
        return new ClientSession(connected, timeToLive, null, queueLimit);
    }

    public long deserializeTimestamp(byte[] bytes) {
        return Bytes.readLong(bytes, 0);
    }
}

