/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.rocksdb.RocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadRocksDBSerializer;
import com.hivemq.util.LocalPersistenceFileUtil;
import javax.annotation.PostConstruct;
import org.rocksdb.FlushOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PublishPayloadRocksDBLocalPersistence
extends RocksDBLocalPersistence
implements PublishPayloadLocalPersistence {
    @VisibleForTesting
    static final Logger log = LoggerFactory.getLogger(PublishPayloadRocksDBLocalPersistence.class);
    private final FlushOptions FLUSH_OPTIONS = new FlushOptions().setAllowWriteStall(true);
    public static final String PERSISTENCE_VERSION = "040500_R";
    private final long memTableSize = PublishPayloadRocksDBLocalPersistence.physicalMemory() / (long)InternalConfigurations.PAYLOAD_PERSISTENCE_MEMTABLE_SIZE_PORTION.get() / (long)InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get();
    private final boolean forceFlush;
    private long @NotNull [] rocksdbToMemTableSize = new long[InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get()];

    @Inject
    public PublishPayloadRocksDBLocalPersistence(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get(), InternalConfigurations.PAYLOAD_PERSISTENCE_MEMTABLE_SIZE_PORTION.get(), InternalConfigurations.PAYLOAD_PERSISTENCE_BLOCK_CACHE_SIZE_PORTION.get(), 32768, InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get() == PersistenceType.FILE_NATIVE);
        this.forceFlush = InternalConfigurations.PUBLISH_PAYLOAD_FORCE_FLUSH_ENABLED.get();
    }

    @Override
    @NotNull
    protected String getName() {
        return "publish_payload_store";
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected void configureOptions(@NotNull Options options) {
        options.setEnableBlobFiles(true).setEnableBlobGarbageCollection(true).setCompressionType(InternalConfigurations.PAYLOAD_PERSISTENCE_BLOB_REFERENCE_COMPRESSION_TYPE).setBlobCompressionType(InternalConfigurations.PAYLOAD_PERSISTENCE_BLOB_COMPRESSION_TYPE).setTargetFileSizeBase(1024L).setMaxBytesForLevelBase(10240L);
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    public void init() {
        try {
            long maxId = 0L;
            for (RocksDB bucket : this.buckets) {
                try (RocksIterator rocksIterator = bucket.newIterator();){
                    rocksIterator.seekToFirst();
                    while (rocksIterator.isValid()) {
                        long key = PublishPayloadRocksDBSerializer.deserializeKey(rocksIterator.key());
                        if (key > maxId) {
                            maxId = key;
                        }
                        rocksIterator.next();
                    }
                }
            }
            PUBLISH.PUBLISH_COUNTER.set(maxId + 1L);
        }
        catch (Exception e) {
            log.error("An error occurred while preparing the Publish Payload persistence.");
            log.debug("Original Exception:", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }

    @Override
    public void put(long id, byte @NotNull [] payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"payload must not be null");
        int index = this.getBucketIndex(Long.toString(id));
        RocksDB bucket = this.buckets[index];
        try {
            bucket.put(PublishPayloadRocksDBSerializer.serializeKey(id), payload);
            if (this.forceFlush) {
                this.flushOnMemTableOverflow(bucket, index, payload.length);
            }
        }
        catch (RocksDBException e) {
            log.error("Could not put a payload because of an exception: ", (Throwable)e);
        }
    }

    @Override
    public byte @Nullable [] get(long id) {
        RocksDB bucket = this.getRocksDb(Long.toString(id));
        try {
            return bucket.get(PublishPayloadRocksDBSerializer.serializeKey(id));
        }
        catch (RocksDBException e) {
            log.error("Could not get a payload because of an exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public ImmutableList<Long> getAllIds() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RocksDB bucket : this.buckets) {
            try (RocksIterator rocksIterator = bucket.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    byte[] key = rocksIterator.key();
                    builder.add((Object)PublishPayloadRocksDBSerializer.deserializeKey(key));
                    rocksIterator.next();
                }
            }
        }
        return builder.build();
    }

    @Override
    public void remove(long id) {
        if (this.stopped.get()) {
            return;
        }
        RocksDB bucket = this.getRocksDb(Long.toString(id));
        try {
            bucket.delete(PublishPayloadRocksDBSerializer.serializeKey(id));
        }
        catch (RocksDBException e) {
            log.error("Could not delete a payload because of an exception: ", (Throwable)e);
        }
    }

    @Override
    public void iterate(@NotNull PublishPayloadLocalPersistence.Callback callback) {
        for (RocksDB bucket : this.buckets) {
            try (RocksIterator rocksIterator = bucket.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    long payloadId = PublishPayloadRocksDBSerializer.deserializeKey(rocksIterator.key());
                    callback.call(payloadId, rocksIterator.value());
                    rocksIterator.next();
                }
            }
        }
    }

    @VisibleForTesting
    long[] getRocksdbToMemTableSize() {
        return this.rocksdbToMemTableSize;
    }

    @VisibleForTesting
    public long getMemTableSize() {
        return this.memTableSize;
    }

    private void flushOnMemTableOverflow(@NotNull RocksDB bucket, int bucketIndex, int payloadSize) throws RocksDBException {
        long updatedSize = (long)payloadSize + this.rocksdbToMemTableSize[bucketIndex];
        if (updatedSize >= this.memTableSize) {
            bucket.flush(this.FLUSH_OPTIONS);
            if (log.isDebugEnabled()) {
                log.debug("Hard flushing memTable due to exceeding memTable limit {}.", (Object)this.memTableSize);
            }
            this.rocksdbToMemTableSize[bucketIndex] = 0L;
        } else {
            this.rocksdbToMemTableSize[bucketIndex] = updatedSize;
        }
    }
}

