/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.util;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.util.BatchedException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureUtils {
    private static final Logger log = LoggerFactory.getLogger(FutureUtils.class);

    public static ListenableFuture<Void> voidFutureFromList(ImmutableList<ListenableFuture<Void>> futures) {
        SettableFuture result = SettableFuture.create();
        Futures.whenAllComplete(futures).call(() -> {
            final ArrayList<Throwable> throwables = new ArrayList<Throwable>();
            for (ListenableFuture future : futures) {
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(Void entry) {
                    }

                    public void onFailure(Throwable t) {
                        throwables.add(t);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
            if (throwables.isEmpty()) {
                result.set(null);
            } else if (throwables.size() == 1) {
                result.setException((Throwable)throwables.get(0));
            } else {
                result.setException((Throwable)new BatchedException(throwables));
            }
            return null;
        }, MoreExecutors.directExecutor());
        return result;
    }

    public static void addExceptionLogger(ListenableFuture<?> listenableFuture) {
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object o) {
            }

            public void onFailure(Throwable throwable) {
                log.error("Uncaught exception", throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

