/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import org.jetbrains.annotations.Nullable;

public class Priority
implements Comparable<Priority> {
    public static final Priority highest = new Priority(0x3FFFFFFF, "The highest possible priority");
    public static final Priority above_normal = new Priority(0x1FFFFFFF, "The above normal priority");
    public static final Priority normal = new Priority(0, "The normal (default) priority");
    public static final Priority below_normal = new Priority(-Priority.above_normal.value, "The below normal priority");
    public static final Priority lowest = new Priority(-Priority.highest.value, "The lowest possible priority");
    private final int value;
    @Nullable
    private final String description;

    private Priority(int value, @Nullable String description) {
        this.value = value;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Priority)) {
            return false;
        }
        Priority priority = (Priority)o;
        return this.value == priority.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(Priority o) {
        return this.value - o.value;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    public static Priority mean(Priority p1, Priority p2) {
        long value = (long)p1.value + (long)p2.value >>> 1;
        return new Priority((int)value, null);
    }
}

