/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.executable;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.basyx.components.aas.AASServerComponent;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASServerExecutable {
    private static Logger logger = LoggerFactory.getLogger(AASServerExecutable.class);

    public static void main(String[] args) throws URISyntaxException {
        String rootPath;
        logger.info("Starting BaSyx AASServer component...");
        BaSyxContextConfiguration contextConfig = new BaSyxContextConfiguration();
        contextConfig.loadFromDefaultSource();
        BaSyxAASServerConfiguration aasConfig = new BaSyxAASServerConfiguration();
        aasConfig.loadFromDefaultSource();
        String docBasePath = rootPath = new File(AASServerExecutable.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath();
        contextConfig.setDocBasePath(docBasePath);
        AASServerComponent component = new AASServerComponent(contextConfig, aasConfig);
        component.startComponent();
        logger.info("BaSyx AAS Server component started");
        AASServerExecutable.addShutdownHook(component);
    }

    private static void addShutdownHook(final AASServerComponent component) {
        Thread shutdownListener = new Thread(){

            @Override
            public void run() {
                component.stopComponent();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownListener);
    }
}

