/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

final class DatabaseRoot {
    static final byte DATABASE_ROOT_TYPE = 1;
    private static final long MAGIC_DIFF = 199L;
    @NotNull
    private final Loggable loggable;
    private final long rootAddress;
    private final int lastStructureId;
    private final boolean isValid;

    DatabaseRoot(@NotNull Loggable loggable) {
        this.loggable = loggable;
        ByteIterator it = loggable.getData().iterator();
        this.rootAddress = CompressedUnsignedLongByteIterable.getLong(it);
        this.lastStructureId = CompressedUnsignedLongByteIterable.getInt(it);
        this.isValid = this.rootAddress == CompressedUnsignedLongByteIterable.getLong(it) - (long)this.lastStructureId - 199L;
    }

    public long getAddress() {
        return this.loggable.getAddress();
    }

    public long length() {
        return this.loggable.length();
    }

    long getRootAddress() {
        return this.rootAddress;
    }

    int getLastStructureId() {
        return this.lastStructureId;
    }

    boolean isValid() {
        return this.isValid;
    }

    static ByteIterable asByteIterable(long rootAddress, int lastStructureId) {
        LightOutputStream output = new LightOutputStream(20);
        CompressedUnsignedLongByteIterable.fillBytes(rootAddress, output);
        CompressedUnsignedLongByteIterable.fillBytes(lastStructureId, output);
        CompressedUnsignedLongByteIterable.fillBytes(rootAddress + (long)lastStructureId + 199L, output);
        return output.asArrayByteIterable();
    }
}

