/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.SoftConcurrentLongObjectCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StoreGetCache {
    private final SoftConcurrentLongObjectCache<ValueEntry> cache;

    StoreGetCache(int cacheSize) {
        this.cache = new SoftConcurrentLongObjectCache(cacheSize);
    }

    void close() {
        this.cache.close();
    }

    @Nullable
    ByteIterable tryKey(long treeRootAddress, @NotNull ByteIterable key) {
        int keyHashCode = key.hashCode();
        ValueEntry ve = (ValueEntry)this.cache.tryKey(treeRootAddress ^ (long)keyHashCode);
        return ve == null || ve.treeRootAddress != treeRootAddress || ve.keyHashCode != keyHashCode || !ve.key.equals(key) ? null : ve.value;
    }

    void cacheObject(long treeRootAddress, @NotNull ByteIterable key, @NotNull ArrayByteIterable value) {
        int keyHashCode = key.hashCode();
        this.cache.cacheObject(treeRootAddress ^ (long)keyHashCode, (Object)new ValueEntry(treeRootAddress, keyHashCode, key, value));
    }

    float hitRate() {
        return this.cache.hitRate();
    }

    private static class ValueEntry {
        private final long treeRootAddress;
        private final int keyHashCode;
        @NotNull
        private final ByteIterable key;
        @NotNull
        private final ArrayByteIterable value;

        ValueEntry(long treeRootAddress, int keyHashCode, @NotNull ByteIterable key, @NotNull ArrayByteIterable value) {
            this.treeRootAddress = treeRootAddress;
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
        }
    }
}

