/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Iterator;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.CursorImpl;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreGetCache;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.TreeCursorMutable;
import jetbrains.exodus.tree.TreeMetaInfo;
import jetbrains.exodus.tree.btree.BTree;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeEmpty;
import jetbrains.exodus.tree.patricia.PatriciaTree;
import jetbrains.exodus.tree.patricia.PatriciaTreeEmpty;
import jetbrains.exodus.tree.patricia.PatriciaTreeWithDuplicates;
import jetbrains.exodus.util.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoreImpl
implements Store {
    @NotNull
    private static final ArrayByteIterable NULL_CACHED_VALUE = new ArrayByteIterable(ByteIterable.EMPTY);
    @NotNull
    private final EnvironmentImpl environment;
    @NotNull
    private final String name;
    @NotNull
    private final TreeMetaInfo metaInfo;

    StoreImpl(@NotNull EnvironmentImpl env, @NotNull String name, @NotNull TreeMetaInfo metaInfo) {
        this.environment = env;
        this.name = StringInterner.intern((String)name);
        this.metaInfo = metaInfo;
    }

    @NotNull
    public EnvironmentImpl getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ByteIterable get(@NotNull Transaction txn, @NotNull ByteIterable key) {
        boolean useStoreGetCache;
        TransactionBase tx = (TransactionBase)txn;
        ITree tree = tx.getTree(this);
        long treeRootAddress = tree.getRootAddress();
        StoreGetCache storeGetCache = this.environment.getStoreGetCache();
        boolean bl = useStoreGetCache = treeRootAddress != -1L && storeGetCache != null;
        if (useStoreGetCache) {
            ByteIterable result = storeGetCache.tryKey(treeRootAddress, key);
            if (result != null) {
                return result == NULL_CACHED_VALUE ? null : result;
            }
            result = tree.get(key);
            storeGetCache.cacheObject(treeRootAddress, key, result == null ? NULL_CACHED_VALUE : new ArrayByteIterable(result));
            return result;
        }
        return tree.get(key);
    }

    public boolean exists(@NotNull Transaction txn, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        return ((TransactionBase)txn).getTree(this).hasPair(key, value);
    }

    public boolean put(@NotNull Transaction txn, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        ITreeMutable mutableTree = EnvironmentImpl.throwIfReadonly(txn, "Can't put in read-only transaction").getMutableTree(this);
        if (mutableTree.put(key, value)) {
            TreeCursorMutable.notifyCursors(mutableTree);
            return true;
        }
        return false;
    }

    public boolean putNotifyNoCursors(@NotNull Transaction txn, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        return EnvironmentImpl.throwIfReadonly(txn, "Can't put in read-only transaction").getMutableTree(this).put(key, value);
    }

    public void putRight(@NotNull Transaction txn, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        ITreeMutable mutableTree = EnvironmentImpl.throwIfReadonly(txn, "Can't put in read-only transaction").getMutableTree(this);
        mutableTree.putRight(key, value);
        TreeCursorMutable.notifyCursors(mutableTree);
    }

    public boolean add(@NotNull Transaction txn, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        ITreeMutable mutableTree = EnvironmentImpl.throwIfReadonly(txn, "Can't add in read-only transaction").getMutableTree(this);
        if (mutableTree.add(key, value)) {
            TreeCursorMutable.notifyCursors(mutableTree);
            return true;
        }
        return false;
    }

    public long count(@NotNull Transaction txn) {
        return ((TransactionBase)txn).getTree(this).getSize();
    }

    public Cursor openCursor(@NotNull Transaction txn) {
        return new CursorImpl(this, (TransactionBase)txn);
    }

    public boolean delete(@NotNull Transaction txn, @NotNull ByteIterable key) {
        ITreeMutable mutableTree = EnvironmentImpl.throwIfReadonly(txn, "Can't delete in read-only transaction").getMutableTree(this);
        if (mutableTree.delete(key)) {
            TreeCursorMutable.notifyCursors(mutableTree);
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void close() {
    }

    @NotNull
    public StoreConfig getConfig() {
        return TreeMetaInfo.toConfig(this.metaInfo);
    }

    public boolean isNew(@NotNull Transaction txn) {
        return !txn.isReadonly() && ((ReadWriteTransaction)txn).isStoreNew(this.name);
    }

    public void persistCreation(@NotNull Transaction txn) {
        EnvironmentImpl.throwIfReadonly(txn, "Read-only transaction is not enough").storeCreated(this);
    }

    @NotNull
    TreeMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void reclaim(@NotNull Transaction transaction, @NotNull RandomAccessLoggable loggable, @NotNull Iterator<RandomAccessLoggable> loggables) {
        ReadWriteTransaction txn = EnvironmentImpl.throwIfReadonly(transaction, "Can't reclaim in read-only transaction");
        boolean wasTreeCreated = txn.hasTreeMutable(this);
        if (!txn.getMutableTree(this).reclaim(loggable, loggables) && !wasTreeCreated) {
            txn.removeTreeMutable(this);
        }
    }

    ITree openImmutableTree(@NotNull MetaTreeImpl metaTree) {
        ITree result;
        int structureId = this.getStructureId();
        long upToDateRootAddress = metaTree.getRootAddress(structureId);
        boolean hasDuplicates = this.metaInfo.hasDuplicates();
        boolean treeIsEmpty = upToDateRootAddress == -1L;
        Log log = this.environment.getLog();
        if (!this.metaInfo.isKeyPrefixing()) {
            BTreeBalancePolicy balancePolicy = this.environment.getBTreeBalancePolicy();
            result = treeIsEmpty ? new BTreeEmpty(log, balancePolicy, hasDuplicates, structureId) : new BTree(log, balancePolicy, upToDateRootAddress, hasDuplicates, structureId);
        } else {
            result = treeIsEmpty ? new PatriciaTreeEmpty(log, structureId, hasDuplicates) : (hasDuplicates ? new PatriciaTreeWithDuplicates(log, upToDateRootAddress, structureId) : new PatriciaTree(log, upToDateRootAddress, structureId));
        }
        return result;
    }

    int getStructureId() {
        return this.metaInfo.getStructureId();
    }
}

