/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.exodus.util.SafeByteBufferCleaner;
import jetbrains.exodus.util.SharedRandomAccessFile;
import org.jetbrains.annotations.NotNull;

final class SharedMappedByteBuffer
implements AutoCloseable {
    @NotNull
    private final ByteBuffer buffer;
    private final AtomicInteger clients;

    SharedMappedByteBuffer(@NotNull SharedRandomAccessFile file) throws IOException {
        this.buffer = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        this.clients = new AtomicInteger();
    }

    void employ() {
        this.clients.incrementAndGet();
    }

    @NotNull
    ByteBuffer getBuffer() {
        return this.buffer.slice();
    }

    @Override
    public void close() {
        if (this.clients.decrementAndGet() < 0) {
            SafeByteBufferCleaner.INSTANCE.clean(this.buffer);
        }
    }
}

