/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.log.LogFileSet;
import org.jetbrains.annotations.NotNull;

public class LogTip {
    private static final byte[] NO_BYTES = new byte[0];
    @NotNull
    final byte[] bytes;
    public final long pageAddress;
    public final int count;
    public final long highAddress;
    public final long approvedHighAddress;
    @NotNull
    final LogFileSet.Immutable logFileSet;

    LogTip(long fileLengthBound) {
        this(fileLengthBound, 0L, 0L);
    }

    LogTip(long fileLengthBound, long pageAddress, long highAddress) {
        this.bytes = NO_BYTES;
        this.pageAddress = pageAddress;
        this.count = -1;
        this.highAddress = this.approvedHighAddress = highAddress;
        this.logFileSet = new LogFileSet.Immutable(fileLengthBound);
    }

    LogTip(@NotNull byte[] bytes, long pageAddress, int count, long highAddress, long approvedHighAddress, @NotNull LogFileSet.Immutable logFileSet) {
        this.bytes = bytes;
        this.pageAddress = pageAddress;
        this.count = count;
        this.highAddress = highAddress;
        this.approvedHighAddress = approvedHighAddress;
        this.logFileSet = logFileSet;
    }

    LogTip withApprovedAddress(long updatedApprovedHighAddress) {
        return new LogTip(this.bytes, this.pageAddress, this.count, this.highAddress, updatedApprovedHighAddress, this.logFileSet);
    }

    LogTip withResize(int updatedCount, long updatedHighAddress, long updatedApprovedHighAddress, @NotNull LogFileSet.Immutable logFileSet) {
        return new LogTip(this.bytes, this.pageAddress, updatedCount, updatedHighAddress, updatedApprovedHighAddress, logFileSet);
    }

    public long[] getAllFiles() {
        return this.logFileSet.getFiles();
    }

    public LongIterator getFilesFrom(long highAddress) {
        return this.logFileSet.getFilesFrom(highAddress);
    }
}

