/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.patricia.AddressIterator;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.PatriciaTraverser;
import jetbrains.exodus.tree.patricia.TreeAwareNodeDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatriciaTreeBase
implements ITree {
    public static final byte MAX_VALID_LOGGABLE_TYPE = 43;
    public static final byte NODE_WO_KEY_WO_VALUE_WO_CHILDREN = 12;
    public static final byte HAS_KEY_BIT = 1;
    public static final byte HAS_VALUE_BIT = 2;
    public static final byte HAS_CHILDREN_BIT = 4;
    public static final byte ROOT_BIT = 8;
    public static final byte ROOT_BIT_WITH_BACKREF = 16;
    @NotNull
    protected final Log log;
    @NotNull
    private final DataIterator dataIterator;
    protected final int structureId;
    protected long size;

    protected PatriciaTreeBase(@NotNull Log log, int structureId) {
        this.log = log;
        this.dataIterator = new DataIterator(log);
        this.structureId = structureId;
    }

    @Override
    @NotNull
    public Log getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public DataIterator getDataIterator(long address) {
        this.dataIterator.checkPage(address);
        return this.dataIterator;
    }

    @Override
    public int getStructureId() {
        return this.structureId;
    }

    @Override
    @Nullable
    public ByteIterable get(@NotNull ByteIterable key) {
        NodeBase node = this.getNode(key);
        return node == null ? null : node.getValue();
    }

    @Override
    public boolean hasPair(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        ByteIterable val = this.get(key);
        return val != null && val.compareTo((Object)value) == 0;
    }

    @Override
    public boolean hasKey(@NotNull ByteIterable key) {
        return this.get(key) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void dump(PrintStream out) {
        this.dump(out, null);
    }

    @Override
    public void dump(PrintStream out, Dumpable.ToString renderer) {
        new TreeAwareNodeDecorator(this, this.getRoot()).dump(out, 0, renderer);
    }

    @Override
    public LongIterator addressIterator() {
        if (this.isEmpty()) {
            return LongIterator.EMPTY;
        }
        return new AddressIterator(new PatriciaTraverser(this, this.getRoot()));
    }

    @NotNull
    final RandomAccessLoggable getLoggable(long address) {
        return this.log.readNotNull(this.getDataIterator(address), address);
    }

    @NotNull
    final ImmutableNode loadNode(long address) {
        RandomAccessLoggable loggable = this.getLoggable(address);
        return new ImmutableNode(address, loggable.getType(), loggable.getData());
    }

    static boolean nodeHasKey(byte type) {
        return (type - 12 & 1) != 0;
    }

    static boolean nodeHasValue(byte type) {
        return (type - 12 & 2) != 0;
    }

    static boolean nodeHasChildren(byte type) {
        return (type - 12 & 4) != 0;
    }

    static boolean nodeIsRoot(byte type) {
        return (type - 12 & 8) != 0;
    }

    static boolean nodeHasBackReference(byte type) {
        return (type - 12 & 0x10) != 0;
    }

    abstract NodeBase getRoot();

    @Nullable
    protected NodeBase getNode(@NotNull ByteIterable key) {
        ByteIterator it = key.iterator();
        NodeBase node = this.getRoot();
        do {
            if (NodeBase.MatchResult.getMatchingLength(node.matchesKeySequence(it)) >= 0) continue;
            return null;
        } while (it.hasNext() && (node = node.getChild(this, it.next())) != null);
        return node;
    }
}

