/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class HeartbeatWatcher {
    private long timeout = 4000L;
    private Map<String, Long> received = Collections.synchronizedMap(new HashMap());
    private ReceptionCallback<?> metricsCallback;
    private ReceptionCallback<?> statusCallback;

    public ReceptionCallback<?> createMetricsReceptionCallback() {
        return new ReceptionCallback<String>(){

            public void received(String data) {
                try {
                    JsonObject obj = Json.createObject((String)data);
                    HeartbeatWatcher.this.notifyRecordReceived(obj.getString("id"));
                }
                catch (IOException e) {
                    LoggerFactory.getLogger((Object)this).warn("While receiving data: {}", (Object)e.getMessage());
                }
            }

            public Class<String> getType() {
                return String.class;
            }
        };
    }

    public ReceptionCallback<?> createStatusReceptionCallback() {
        return new ReceptionCallback<StatusMessage>(){

            public void received(StatusMessage msg) {
                if (ActionTypes.REMOVED == msg.getAction()) {
                    HeartbeatWatcher.this.notifyRecordDeleted(msg.getDeviceId());
                } else {
                    HeartbeatWatcher.this.notifyRecordReceived(msg.getDeviceId());
                }
            }

            public Class<StatusMessage> getType() {
                return StatusMessage.class;
            }
        };
    }

    public void installInto(TransportConnector connector) throws IOException {
        if (null == connector) {
            throw new IOException("No transport connector given");
        }
        this.metricsCallback = this.createMetricsReceptionCallback();
        this.statusCallback = this.createStatusReceptionCallback();
        connector.setReceptionCallback("ServiceMetrics", this.metricsCallback);
        connector.setReceptionCallback("EcsMetrics", this.metricsCallback);
        connector.setReceptionCallback("ComponentStatus", this.statusCallback);
        LoggerFactory.getLogger(HeartbeatWatcher.class).info("Installed watcher on {}, {} and {}", new Object[]{"ServiceMetrics", "EcsMetrics", "ComponentStatus"});
    }

    public void uninstallFrom(TransportConnector connector) throws IOException {
        if (null == connector) {
            throw new IOException("No transport connector given");
        }
        if (null != this.metricsCallback) {
            connector.detachReceptionCallback("ServiceMetrics", this.metricsCallback);
            connector.detachReceptionCallback("EcsMetrics", this.metricsCallback);
            LoggerFactory.getLogger(HeartbeatWatcher.class).info("Uninstalled watcher from {} and {}", (Object)"ServiceMetrics", (Object)"EcsMetrics");
        }
        if (null != this.statusCallback) {
            connector.detachReceptionCallback("ComponentStatus", this.statusCallback);
            LoggerFactory.getLogger(HeartbeatWatcher.class).info("Uninstalled watcher from {}", (Object)"ComponentStatus");
        }
        this.metricsCallback = null;
        this.statusCallback = null;
    }

    public void notifyRecordReceived(String deviceId) {
        if (null != deviceId && deviceId.length() > 0) {
            this.received.put(deviceId, System.currentTimeMillis());
        }
    }

    public void notifyRecordDeleted(String deviceId) {
        if (null != deviceId) {
            this.received.remove(deviceId);
        }
    }

    public void deleteOutdated(Consumer<String> outdatedHandler) {
        this.deleteOutdated(this.timeout, outdatedHandler);
    }

    public void deleteOutdated(long timeout, Consumer<String> outdatedHandler) {
        Map.Entry entry;
        long lastNotified;
        long now = System.currentTimeMillis();
        ArrayList<Map.Entry<String, Long>> tmp = new ArrayList<Map.Entry<String, Long>>();
        tmp.addAll(this.received.entrySet());
        Collections.sort(tmp, (e1, e2) -> Long.compare((Long)e1.getValue(), (Long)e2.getValue()));
        for (int i = 0; i < tmp.size() && now - (lastNotified = ((Long)(entry = (Map.Entry)tmp.get(i)).getValue()).longValue()) > timeout; ++i) {
            String deviceId = (String)entry.getKey();
            this.received.remove(deviceId);
            outdatedHandler.accept(deviceId);
        }
    }

    public int getDeviceCount() {
        return this.received.size();
    }

    public void clear() {
        this.received.clear();
    }

    public long setTimeout(long tout) {
        long orig = this.timeout;
        this.timeout = tout;
        return orig;
    }
}

