/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas;

import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonNumber;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonValue;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MetricsAasConstructor {
    public static final CollectionSupplier ALL_ELEMENTS_SUPPLIER = new CollectionSupplier(){

        @Override
        public List<ElementsAccess> get(ElementsAccess parent, String deviceId) {
            ArrayList<ElementsAccess> result = null;
            SubmodelElementCollection coll = parent.getSubmodelElementCollection(AasUtils.fixId((String)"services"));
            if (coll instanceof SubmodelElementCollection) {
                SubmodelElementCollection sec = coll;
                result = new ArrayList<ElementsAccess>();
                String fDeviceId = AasUtils.fixId((String)deviceId);
                for (SubmodelElement e : sec.elements()) {
                    if (!(e instanceof ElementsAccess)) continue;
                    ElementsAccess ea = (ElementsAccess)e;
                    Property state = ea.getProperty("state");
                    Property resource = ea.getProperty("resource");
                    if (null == resource || state == null) continue;
                    try {
                        boolean stateOk;
                        Object tmpStateVal = state.getValue();
                        String stateVal = null == tmpStateVal ? "" : tmpStateVal.toString();
                        boolean bl = stateOk = stateVal.length() > 0 && !"AVAILABLE".equals(state);
                        if (!fDeviceId.equals(resource.getValue()) || !stateOk) continue;
                        result.add(ea);
                    }
                    catch (ExecutionException ex) {
                        LoggerFactory.getLogger(MetricsAasConstructor.class).warn("Cannot read resource property: {}", (Object)ex.getMessage());
                    }
                }
            }
            return result;
        }
    };
    public static final CollectionSupplier DFLT_SUBMODEL_SUPPLIER = (p, id) -> CollectionUtils.toList((Object[])new ElementsAccess[]{p.getSubmodelElementCollection(AasUtils.fixId((String)id))});
    public static final PushMeterPredicate PREDICATE_ALWAYS_TRUE = (p, j) -> true;
    public static final boolean LAMBDA_SETTERS_SUPPORTED = AasFactory.getInstance().supportsPropertyFunctions();
    public static final boolean RECEIVE_METRICS_FROM_TRANSPORT = true;
    private static Map<String, TransportConnector> conns = new HashMap<String, TransportConnector>();
    private static Map<String, JsonObjectHolder> holders = new HashMap<String, JsonObjectHolder>();
    private static Submodel monSubModel;
    private static boolean monSubModelFailed;
    private static Map<String, String> monMapping;

    public static void clear() {
        for (Map.Entry<String, TransportConnector> ent : conns.entrySet()) {
            try {
                ent.getValue().disconnect();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Cannot disconnect transport connector for id " + ent.getKey() + ": " + e.getMessage());
            }
        }
        conns.clear();
        holders.clear();
    }

    private static TransportConnector getTransportConnector(String channel, TransportSetup setup, Supplier<ReceptionCallback<?>> callbackSupplier) {
        TransportConnector conn = conns.get(channel);
        if (null == conn && !conns.containsKey(channel)) {
            conn = TransportFactory.createConnector();
            try {
                conn.connect(setup.createParameter());
                conn.setReceptionCallback(channel, callbackSupplier.get());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Cannot create connector: " + e.getMessage());
            }
            conns.put(channel, conn);
        }
        return conn;
    }

    public static Map<String, String> getMonitoringMapping() {
        return Collections.unmodifiableMap(monMapping);
    }

    public static void pushToAas(String json, String submodel, CollectionSupplier cSupplier, boolean update, PushMeterPredicate mPredicate) {
    }

    public static void pushToAasAlways(String json, String submodel, CollectionSupplier cSupplier, boolean update, PushMeterPredicate mPredicate) {
        MetricsAasConstructor.pushToAas(json, submodel, cSupplier, update, monMapping, mPredicate);
    }

    public static void pushToAas(String json, String submodel, CollectionSupplier cSupplier, boolean update, Map<String, String> monMapping, PushMeterPredicate mPredicate) {
        if (!LAMBDA_SETTERS_SUPPORTED && null == monSubModel && !monSubModelFailed) {
            try {
                monSubModel = ActiveAasBase.getSubmodel((String)submodel);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Obtaining submodel '{}' to push monitoring data to failed: {}", (Object)submodel, (Object)e.getMessage());
                System.out.println("ERROR: " + e.getMessage());
                monSubModelFailed = true;
            }
        }
        if (null != monSubModel) {
            mPredicate = null == mPredicate ? PREDICATE_ALWAYS_TRUE : mPredicate;
            try {
                JsonObject meters;
                List<ElementsAccess> coll;
                JsonObject obj = Json.createObject((String)json);
                String id = obj.getString("id");
                if (null != id && null != (coll = cSupplier.get((ElementsAccess)monSubModel, id)) && null != (meters = obj.getJsonObject("meters"))) {
                    for (ElementsAccess c : coll) {
                        for (String k : meters.keys()) {
                            MetricsAasConstructor.pushToAas(c, k, meters.getValue(k), monMapping, mPredicate);
                        }
                    }
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).warn("Cannot parse meter: {}", (Object)e.getMessage());
            }
        }
    }

    private static void pushToAas(ElementsAccess coll, String key, JsonValue json, Map<String, String> monMapping, PushMeterPredicate mPredicate) {
        String idShort = monMapping.get(key);
        if (null != idShort && mPredicate.test(coll, json)) {
            AasUtils.setPropertyValueSafe((ElementsAccess)coll, (String)idShort, (Object)MetricsAasConstructor.getMeasurement(json.toString()));
        }
    }

    private static Object getMeasurement(String json) {
        Double result = null;
        if (null != json && json.length() > 0) {
            try {
                JsonNumber num;
                JsonObject measurement;
                JsonObject obj = Json.createObject((String)json);
                JsonArray meas = obj.getJsonArray("measurements");
                if (null != meas && meas.size() > 0 && null != (measurement = meas.getJsonObject(0)) && null != (num = measurement.getJsonNumber("value"))) {
                    result = num.doubleValue();
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).warn("Cannot parse measurement: {}", (Object)e.getMessage());
            }
        }
        return result;
    }

    private static JsonObjectHolder getHolder(String id, String channel, TransportSetup setup) {
        MetricsAasConstructor.getTransportConnector(channel, setup, () -> new MetricsReceptionCallback());
        JsonObjectHolder result = holders.get(id);
        if (null == result) {
            result = new JsonObjectHolder();
            holders.put(id, result);
        }
        return result;
    }

    public static boolean containsMetrics(SubmodelElementCollection sub) {
        return sub.getElement("Storage_Free") != null;
    }

    public static Property createProperty(SubmodelElementContainerBuilder smBuilder, Type type, String channel, String id, TransportSetup setup, String metricsName, String semId) {
        String idShort = monMapping.get(metricsName);
        Property.PropertyBuilder pBuilder = smBuilder.createPropertyBuilder(idShort).setType(type);
        if (LAMBDA_SETTERS_SUPPORTED) {
            pBuilder.bind((Invokable)new MeterGetter(channel, id, setup, metricsName), InvocablesCreator.READ_ONLY);
        } else {
            MetricsAasConstructor.getTransportConnector(channel, setup, () -> new PushingMetricsReceptionCallback());
            Number dflt = switch (type) {
                case Type.AAS_INTEGER -> 0;
                case Type.FLOAT -> 0.0;
                case Type.DOUBLE -> 0.0;
                case Type.INTEGER -> 0;
                default -> null;
            };
            if (null != dflt) {
                pBuilder.setValue((Object)dflt);
            }
        }
        if (null != semId) {
            pBuilder.setSemanticId(semId);
        }
        return (Property)pBuilder.build();
    }

    public static void addProviderMetricsToAasSubmodel(SubmodelElementContainerBuilder smBuilder, Predicate<String> filter, String channel, String id, TransportSetup setup) {
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.disk.free", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.disk.total", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.disk.usable", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.disk.used", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.memory.free", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.memory.total", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.memory.usage", "irdi:0173-1#05-AAA129#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "system.memory.used", "irdi:0173-1#05-AAA766#003");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "device.cpu.temperature", "irdi:0173-1#05-AAA567#004");
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "device.case.temperature", "irdi:0173-1#05-AAA567#004");
    }

    public static void addServiceMetricsToAasSubmodel(SubmodelElementContainerBuilder smBuilder, Predicate<String> filter, String channel, String id, TransportSetup setup) {
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "service.sent", null);
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "service.received", null);
        MetricsAasConstructor.createProperty(smBuilder, Type.DOUBLE, channel, id, setup, "service.processed", "irdi:0173-1#05-AAA114#003");
    }

    public static void removeProviderMetricsFromAasSubmodel(SubmodelElementCollection sub) {
        sub.deleteElement("Storage_Free");
        sub.deleteElement("Storage_Capacity");
        sub.deleteElement("Storage_Usable");
        sub.deleteElement("Allocated_Storage");
        sub.deleteElement("Memory_Free");
        sub.deleteElement("Memory_Capacity");
        sub.deleteElement("Allocated_Memory");
        sub.deleteElement("Memory_Used");
    }

    public static void clearProviderMetricsInAasSubmodel(SubmodelElementCollection sub) {
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Storage_Free", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Storage_Capacity", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Storage_Usable", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Allocated_Storage", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Memory_Free", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Memory_Capacity", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Allocated_Memory", (Object)0.0);
        AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)"Memory_Used", (Object)0.0);
    }

    static {
        monSubModelFailed = false;
        monMapping = new HashMap<String, String>();
        monMapping.put("system.disk.free", "Storage_Free");
        monMapping.put("system.disk.total", "Storage_Capacity");
        monMapping.put("system.disk.usable", "Storage_Usable");
        monMapping.put("system.disk.used", "Allocated_Storage");
        monMapping.put("system.memory.free", "Memory_Free");
        monMapping.put("system.memory.total", "Memory_Capacity");
        monMapping.put("system.memory.usage", "Allocated_Memory");
        monMapping.put("system.memory.used", "Memory_Used");
        monMapping.put("device.cpu.temperature", "CPU_Temperature");
        monMapping.put("device.case.temperature", "Case_Temperature");
        monMapping.put("service.sent", "Service_Sent");
        monMapping.put("service.received", "Service_Received");
        monMapping.put("service.processed", "Service_Processed");
    }

    public static interface CollectionSupplier {
        public List<ElementsAccess> get(ElementsAccess var1, String var2);
    }

    public static interface PushMeterPredicate {
        public boolean test(ElementsAccess var1, JsonValue var2);
    }

    private static class JsonObjectHolder {
        private JsonObject obj;

        private JsonObjectHolder() {
        }

        public String getMeter(String name) {
            JsonObject meter;
            JsonObject meters;
            String result = "";
            if (null != this.obj && null != (meters = this.obj.getJsonObject("meters")) && null != (meter = meters.getJsonObject(name))) {
                result = meter.toString();
            }
            return result;
        }
    }

    private static class MeterGetter
    implements Invokable.GetterInvokable,
    Serializable {
        private static final long serialVersionUID = 2294254606334816252L;
        private String name;
        private String id;
        private String channel;
        private TransportSetup setup;

        private MeterGetter(String channel, String id, TransportSetup setup, String name) {
            this.id = id;
            this.name = name;
            this.channel = channel;
            this.setup = setup;
        }

        public Object get() {
            String json = MetricsAasConstructor.getHolder(this.id, this.channel, this.setup).getMeter(this.name);
            return MetricsAasConstructor.getMeasurement(json);
        }
    }

    private static class PushingMetricsReceptionCallback
    implements ReceptionCallback<String> {
        private PushingMetricsReceptionCallback() {
        }

        public void received(String data) {
            MetricsAasConstructor.pushToAas(data, "services", ALL_ELEMENTS_SUPPLIER, true, monMapping, MetricsProvider.TAG_PREDICATE);
        }

        public Class<String> getType() {
            return String.class;
        }
    }

    private static class MetricsReceptionCallback
    implements ReceptionCallback<String> {
        private MetricsReceptionCallback() {
        }

        public void received(String data) {
            try {
                JsonObjectHolder holder;
                JsonObject obj = Json.createObject((String)data);
                String id = obj.getString("id");
                if (null != id && null != (holder = holders.get(id))) {
                    holder.obj = obj;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Cannot parse JSON: " + e.getMessage() + " " + data);
            }
        }

        public Class<String> getType() {
            return String.class;
        }
    }
}

