/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.services.Sender;
import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.services.environment.services.TransportConverterFactory;
import de.iip_ecosphere.platform.services.environment.services.TransportToWsConverter;
import de.iip_ecosphere.platform.services.environment.services.WsSenderClient;
import de.iip_ecosphere.platform.services.environment.services.WsWatcher;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NoOpServer;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.net.URI;

public class WsTransportConverterFactory
extends TransportConverterFactory {
    public static final WsTransportConverterFactory INSTANCE = new WsTransportConverterFactory();

    private WsTransportConverterFactory() {
    }

    @Override
    protected <T> Sender<T> createSenderImpl(Endpoint endpoint, TypeTranslator<T, String> translator, Class<T> cls) {
        return WsTransportConverterFactory.createWithUri(endpoint, u -> new WsSenderClient((URI)u, translator));
    }

    @Override
    protected <T> TransportConverter.Watcher<T> createWatcherImpl(Endpoint endpoint, TypeTranslator<T, String> translator, Class<T> cls, int period) {
        return WsTransportConverterFactory.createWithUri(endpoint, u -> new WsWatcher((URI)u, translator));
    }

    @Override
    public <T> TransportConverter<T> createConverterImpl(Endpoint endpoint, String transportStream, TypeTranslator<T, String> translator, Class<T> cls) {
        return new TransportToWsConverter<T>(transportStream, cls, endpoint, translator);
    }

    @Override
    public Server createServer(ServerAddress address) {
        try {
            return WebsocketFactory.getInstance().createBroadcastingServer(address);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(WsTransportConverterFactory.class).error("Cannot start websocket broadcasting server: {}", (Object)e.getMessage());
            return new NoOpServer();
        }
    }

    @Override
    public Endpoint getGatewayEndpoint(AasPartRegistry.AasSetup aas, TransportSetup transport, String path) {
        return transport.getGatewayServerEndpoint(TransportToWsConverter.SCHEMA, path);
    }
}

