/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.rabbitmq.RabbitMqAmqpTransportFactoryDescriptor;
import java.io.File;
import java.io.IOException;
import org.junit.Test;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.FakeAuthConnector;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8S;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8STLS;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;

public class MasterAmqpJavaK8SProxy {
    private static int localPort = 6443;
    private static int mqttPort = 9922;
    private static String serverIP = "Empty";
    private static String serverPort = "6443";
    private static boolean tlsCheck = false;

    public static int getLocalPort() {
        return localPort;
    }

    public static void setLocalPort(int localPort) {
        MasterAmqpJavaK8SProxy.localPort = localPort;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static void setServerIP(String serverIP) {
        MasterAmqpJavaK8SProxy.serverIP = serverIP;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static void setServerPort(String serverPort) {
        MasterAmqpJavaK8SProxy.serverPort = serverPort;
    }

    public int getMqttPort() {
        return mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        MasterAmqpJavaK8SProxy.mqttPort = mqttPort;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            serverIP = args[0];
            System.out.println("Api Server IP:" + serverIP);
        } else {
            System.out.println("No Api Server IP passed");
        }
        if (args.length > 1) {
            tlsCheck = Boolean.parseBoolean(args[1]);
            if (tlsCheck) {
                System.out.println("Security option Enabled");
            } else {
                System.out.println("Security option Disabled");
            }
        } else {
            System.out.println("No security option passed, default false");
        }
        if (new File("/tmp/EndServerRun.k8s").exists()) {
            System.out.println("/tmp/EndServerRun.k8s is exist and stop the Client");
            return;
        }
        ServerAddress addr = new ServerAddress(Schema.IGNORE, serverIP, mqttPort);
        TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)RabbitMqAmqpTransportFactoryDescriptor.MAIN);
        TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)new TransportFactory.ConnectorCreator(){

            public TransportConnector createConnector() {
                return new FakeAuthConnector();
            }

            public String getName() {
                return "AMQP";
            }
        });
        TestQpidServer server = new TestQpidServer(addr);
        AbstractTransportConnectorTest.TransportParameterConfigurer configurer = null;
        if (tlsCheck) {
            File secCfg = new File("./src/test/AMQP/secCfg");
            TestQpidServer.setConfigDir((File)secCfg);
            configurer = new AbstractTransportConnectorTest.TransportParameterConfigurer(){

                public void configure(TransportParameter.TransportParameterBuilder builder) {
                    builder.setAuthenticationKey("amqp");
                    builder.setKeystoreKey("amqpKeyStore");
                }
            };
        } else {
            TestQpidServer.setConfigDir(null);
        }
        server.start();
        TransportK8STLS transportK8STLS = new TransportK8STLS(tlsCheck, configurer);
        TransportK8S amqp = new TransportK8S(ProxyType.MasterProxy, addr, serverIP, serverPort, tlsCheck);
        amqp.start(transportK8STLS);
        while (true) {
            if (new File("/tmp/EndServerRun.k8s").exists()) {
                try {
                    amqp.setStopped(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            TimeUtils.sleep((int)1);
        }
        server.stop(true);
    }

    @Test(timeout=120000L)
    public void mainTest() {
        tlsCheck = Boolean.valueOf(System.getProperty("tlsCheck"));
        ServerAddress addr = new ServerAddress(Schema.IGNORE, serverIP, mqttPort);
        TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)RabbitMqAmqpTransportFactoryDescriptor.MAIN);
        TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)new TransportFactory.ConnectorCreator(){

            public TransportConnector createConnector() {
                return new FakeAuthConnector();
            }

            public String getName() {
                return "AMQP";
            }
        });
        TestQpidServer server = new TestQpidServer(addr);
        AbstractTransportConnectorTest.TransportParameterConfigurer configurer = null;
        if (tlsCheck) {
            File secCfg = new File("./src/test/AMQP/secCfg");
            TestQpidServer.setConfigDir((File)secCfg);
            configurer = new AbstractTransportConnectorTest.TransportParameterConfigurer(){

                public void configure(TransportParameter.TransportParameterBuilder builder) {
                    builder.setAuthenticationKey("amqp");
                    builder.setKeystoreKey("amqpKeyStore");
                }
            };
        } else {
            TestQpidServer.setConfigDir(null);
        }
        server.start();
        TransportK8STLS transportK8STLS = new TransportK8STLS(tlsCheck, configurer);
        TransportK8S amqp = new TransportK8S(ProxyType.MasterProxy, addr, serverIP, serverPort, tlsCheck);
        amqp.start(transportK8STLS);
        while (true) {
            TimeUtils.sleep((int)1);
        }
    }
}

