/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.TransportMessage;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ConcurrentLinkedDeque;
import okhttp3.Response;
import okio.Buffer;
import org.bouncycastle.util.Arrays;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.CallbackMessage;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8SJavaProxy;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8STLS;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportMessageJsonSerializer;

public class TransportK8S {
    private static String serverIP;
    private static String serverPort;
    private static K8SJavaProxy transportK8SJavaProxy;
    private static boolean isStopped;
    private ServerAddress addr;
    private ProxyType proxyType;
    private TransportConnector cl1;

    public TransportK8S(ProxyType proxyType, ServerAddress addr, String serverIP, String serverPort, boolean tlsCheck) {
        this.addr = addr;
        TransportK8S.serverIP = serverIP;
        TransportK8S.serverPort = serverPort;
        this.proxyType = proxyType;
        transportK8SJavaProxy = new TransportK8SJavaProxy(ProxyType.MasterProxy, serverIP, serverPort, tlsCheck);
    }

    public ServerAddress getAddr() {
        return this.addr;
    }

    public void setAddr(ServerAddress addr) {
        this.addr = addr;
    }

    public String getServerIP() {
        return serverIP;
    }

    public void setServerIP(String serverIP) {
        TransportK8S.serverIP = serverIP;
    }

    public String getServerPort() {
        return serverPort;
    }

    public void setServerPort(String serverPort) {
        TransportK8S.serverPort = serverPort;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public boolean isStopped() {
        return isStopped;
    }

    public void setStopped(boolean isStopped) throws IOException {
        this.cl1.disconnect();
        TransportK8S.isStopped = isStopped;
    }

    public void start(TransportK8STLS transportK8STLS) {
        final ConcurrentLinkedDeque transportMessagesList = new ConcurrentLinkedDeque();
        SerializerRegistry.registerSerializer(TransportMessageJsonSerializer.class);
        TransportParameter.TransportParameterBuilder tpb1 = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)this.addr).setApplicationId("cl1");
        if (transportK8STLS.isTlsCheck()) {
            transportK8STLS.getConfigurer().configure(tpb1);
        }
        TransportParameter param1 = tpb1.build();
        this.cl1 = TransportFactory.createConnector();
        try {
            this.cl1.connect(param1);
            String stream1 = this.cl1.composeStreamName("", "stream1");
            String watchStream1 = this.cl1.composeStreamName("", "watchStream1");
            final CallbackMessage cb1 = new CallbackMessage();
            final CallbackMessage watchcb1 = new CallbackMessage();
            this.cl1.setReceptionCallback(stream1, (ReceptionCallback)cb1);
            this.cl1.setReceptionCallback(watchStream1, (ReceptionCallback)watchcb1);
            Thread requestMessageAddingThread = new Thread(){

                @Override
                public void run() {
                    while (!isStopped) {
                        if (!cb1.dequeIsEmpty()) {
                            transportMessagesList.add(cb1.getData());
                            continue;
                        }
                        if (!watchcb1.dequeIsEmpty()) {
                            transportMessagesList.add(watchcb1.getData());
                            continue;
                        }
                        TimeUtils.sleep((int)1);
                    }
                }
            };
            requestMessageAddingThread.start();
            Thread requestThread = new Thread(){

                @Override
                public void run() {
                    while (!isStopped) {
                        if (transportMessagesList.isEmpty()) {
                            TimeUtils.sleep((int)1);
                            continue;
                        }
                        final TransportMessage tempMessage = (TransportMessage)transportMessagesList.removeFirst();
                        Thread requestThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    TransportMessage responseMessage = new TransportMessage("Empty", null, "Empty");
                                    String stream2 = TransportK8S.this.cl1.composeStreamName("", tempMessage.getStreamId());
                                    responseMessage.setStreamId(tempMessage.getStreamId());
                                    responseMessage.setRequestWatch(tempMessage.getRequestWatch());
                                    if (TransportK8S.this.proxyType == ProxyType.MasterProxy) {
                                        if (tempMessage.getRequestWatch().equals("Yes")) {
                                            responseMessage.setMessageByte(TransportK8S.this.sendWatchToK8S(tempMessage, TransportK8S.this.cl1));
                                        } else {
                                            responseMessage.setMessageByte(TransportK8S.this.sendToK8S(tempMessage));
                                        }
                                    } else {
                                        responseMessage.setMessageByte(TransportK8S.sendToMasterTransport(tempMessage));
                                    }
                                    TransportK8S.this.cl1.asyncSend(stream2, (Object)responseMessage);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        requestThread.start();
                    }
                }
            };
            requestThread.start();
            File file = new File("ServerReady.k8s");
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] sendToMasterTransport(TransportMessage received) {
        byte[] response = null;
        ServerAddress addr = new ServerAddress(Schema.IGNORE, serverIP, Integer.parseInt(serverPort));
        TransportMessage message1 = new TransportMessage("PCstream", received.getMessageByte(), received.getRequestWatch());
        message1.generateStreamIdNo();
        SerializerRegistry.registerSerializer(TransportMessageJsonSerializer.class);
        TransportParameter param1 = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setApplicationId("cl1").build();
        TransportConnector cl1 = TransportFactory.createConnector();
        try {
            cl1.connect(param1);
            String stream1 = cl1.composeStreamName("", "stream1");
            String stream2 = cl1.composeStreamName("", message1.getStreamId());
            cl1.asyncSend(stream1, (Object)message1);
            CallbackMessage cb1 = new CallbackMessage();
            cl1.setReceptionCallback(stream2, (ReceptionCallback)cb1);
            while (cb1.dequeIsEmpty()) {
                TimeUtils.sleep((int)1);
            }
            response = cb1.getData().getMessageByte();
            cl1.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SerializerRegistry.unregisterSerializer(TransportMessageJsonSerializer.class);
        return response;
    }

    private byte[] sendToK8S(TransportMessage received) {
        K8SRequest request = new K8SRequest();
        byte[] requestByte = received.getMessageByte();
        request = transportK8SJavaProxy.createK8SRequest(requestByte);
        byte[] response = null;
        try {
            response = transportK8SJavaProxy.sendK8SRequest(null, request);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] sendWatchToK8S(TransportMessage received, TransportConnector connector) throws IOException {
        TransportMessage responseMessage;
        Buffer buffer;
        K8SRequest request = new K8SRequest();
        byte[] requestByte = received.getMessageByte();
        request = transportK8SJavaProxy.createK8SRequest(requestByte);
        byte[] responseBody = new byte[]{};
        String responseString = "";
        Response response = transportK8SJavaProxy.executeWatchK8SJavaClientRequest(request);
        String formattedHeaderResponse = request.getProtocol() + " " + response.code() + " " + response.message() + "\r\n" + response.headers().toString() + "\r\n";
        responseBody = formattedHeaderResponse.getBytes();
        String stream2 = connector.composeStreamName("", received.getStreamId());
        try {
            if (!response.body().source().exhausted()) {
                if (formattedHeaderResponse.contains("application/vnd.kubernetes.protobuf")) {
                    buffer = new Buffer();
                    response.body().source().read(buffer, 4096L);
                    responseBody = buffer.readByteArray();
                } else {
                    long count = response.body().source().indexOf((byte)10);
                    responseBody = response.body().source().readByteArray(count + 1L);
                }
                responseBody = this.getResponseMessage(responseBody, formattedHeaderResponse);
                responseMessage = new TransportMessage(received.getStreamId(), responseBody, received.getRequestWatch());
                connector.syncSend(stream2, (Object)responseMessage);
            }
        }
        catch (IOException e) {
            if (e.getMessage().contentEquals("timeout") || e.getMessage().contentEquals("Read timed out")) {
                response.body().close();
                return (formattedHeaderResponse + "0\r\n\r\n").getBytes();
            }
            e.printStackTrace();
        }
        if (responseString.contains("code\":410")) {
            responseBody = "0\r\n\r\n".getBytes();
            if (responseBody == null || responseBody.length == 0) {
                responseBody = "0\r\n\r\n".getBytes();
                System.out.println("Empty response AAS execute");
            }
            response.body().close();
            return responseBody;
        }
        while (true) {
            responseString = "";
            responseBody = new byte[]{};
            try {
                if (response.body().source().exhausted()) {
                    response.body().close();
                    return "0\r\n\r\n".getBytes();
                }
                if (formattedHeaderResponse.contains("application/vnd.kubernetes.protobuf")) {
                    buffer = new Buffer();
                    response.body().source().read(buffer, 4096L);
                    responseBody = buffer.readByteArray();
                } else {
                    long count = response.body().source().indexOf((byte)10);
                    responseBody = response.body().source().readByteArray(count + 1L);
                }
                responseBody = this.getResponseMessage(responseBody, null);
                responseMessage = new TransportMessage(received.getStreamId(), responseBody, received.getRequestWatch());
                connector.syncSend(stream2, (Object)responseMessage);
            }
            catch (IOException e) {
                if (!e.getMessage().contentEquals("timeout") && !e.getMessage().contentEquals("Read timed out")) {
                    e.printStackTrace();
                    return "0\r\n\r\n".getBytes();
                }
                response.body().close();
                return "0\r\n\r\n".getBytes();
            }
        }
    }

    private byte[] getResponseMessage(byte[] responseBody, String formattedHeaderResponse) {
        byte[] firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
        responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
        responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
        if (formattedHeaderResponse != null) {
            responseBody = Arrays.concatenate((byte[])formattedHeaderResponse.getBytes(), (byte[])responseBody);
        }
        return responseBody;
    }

    static {
        isStopped = false;
    }
}

