/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto;

import java.io.FilterInputStream;
import java.io.InputStream;
import jetbrains.exodus.crypto.KryptKt;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.crypto.StreamCipherInputStream;
import jetbrains.exodus.kotlin.KodusKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/crypto/StreamCipherInputStream;", "Ljava/io/FilterInputStream;", "input", "Ljava/io/InputStream;", "cipherGetter", "Lkotlin/Function0;", "Ljetbrains/exodus/crypto/StreamCipher;", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function0;)V", "cipher", "position", "", "savedPosition", "mark", "", "readlimit", "read", "bytes", "", "off", "len", "reset", "xodus-openAPI"})
public final class StreamCipherInputStream
extends FilterInputStream {
    private StreamCipher cipher;
    private int position;
    private int savedPosition;
    private final Function0<StreamCipher> cipherGetter;

    @Override
    public int read() {
        int n;
        int b2 = super.read();
        if (b2 == -1) {
            return -1;
        }
        int $receiver = n = KryptKt.cryptAsInt(this.cipher, (byte)b2);
        StreamCipherInputStream streamCipherInputStream = this;
        ++streamCipherInputStream.position;
        int cfr_ignored_0 = streamCipherInputStream.position;
        return n;
    }

    @Override
    public int read(@Nullable byte[] bytes) {
        byte[] b2 = (byte[])KodusKt.notNull((Object)bytes, (Function0)read.b.1.INSTANCE);
        return this.read(b2, 0, b2.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(@Nullable byte[] bytes, int off, int len) {
        byte[] b2 = (byte[])KodusKt.notNull((Object)bytes, (Function0)read.b.2.INSTANCE);
        int read2 = super.read(b2, off, len);
        if (read2 > 0) {
            int n = off;
            int n2 = read2 + off;
            while (n < n2) {
                void i;
                b2[i] = this.cipher.crypt(b2[i]);
                ++i;
            }
            this.position += read2;
        }
        return read2;
    }

    @Override
    public void reset() {
        super.reset();
        this.cipher = (StreamCipher)this.cipherGetter.invoke();
        int n = this.savedPosition;
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            do {
                int it = ++n2;
                this.cipher.crypt((byte)0);
            } while (n2 != n3);
        }
        this.position = this.savedPosition;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
        this.savedPosition = this.position;
    }

    public StreamCipherInputStream(@NotNull InputStream input, @NotNull Function0<? extends StreamCipher> cipherGetter) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(cipherGetter, (String)"cipherGetter");
        super(input);
        this.cipherGetter = cipherGetter;
        this.cipher = (StreamCipher)this.cipherGetter.invoke();
    }
}

