/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class GenericJsonSerializer<T>
implements Serializer<T> {
    private ObjectMapper mapper = new ObjectMapper();
    private Class<T> cls;

    public GenericJsonSerializer(Class<T> cls) {
        this.cls = cls;
        JsonUtils.handleIipDataClasses((ObjectMapper)this.mapper);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public T from(byte[] data) throws IOException {
        try {
            return (T)this.mapper.readValue(data, this.cls);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(T source) throws IOException {
        try {
            return this.mapper.writeValueAsBytes(source);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public T clone(T origin) throws IOException {
        Constructor<T> c;
        T result = null;
        try {
            c = this.cls.getConstructor(this.cls);
            result = c.newInstance(origin);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        if (null == result) {
            try {
                c = this.cls.getConstructor(new Class[0]);
                result = c.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot create cloned instance of {}: {}", origin, (Object)e.getMessage());
            }
        }
        return result;
    }

    @Override
    public Class<T> getType() {
        return this.cls;
    }
}

