/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.bundle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASBundleFactory {
    private static Logger logger = LoggerFactory.getLogger(AASBundleFactory.class);

    public Set<AASBundle> create(Collection<? extends IAssetAdministrationShell> shells, Collection<? extends ISubmodel> submodels, Collection<? extends IAsset> assets) {
        HashSet<AASBundle> bundles = new HashSet<AASBundle>();
        for (IAssetAdministrationShell iAssetAdministrationShell : shells) {
            if (this.shouldSetAsset(iAssetAdministrationShell)) {
                this.setAsset(assets, iAssetAdministrationShell);
            }
            Set<ISubmodel> currentSM = this.retrieveSubmodelsForAAS(submodels, iAssetAdministrationShell);
            bundles.add(new AASBundle(iAssetAdministrationShell, currentSM));
        }
        return bundles;
    }

    private boolean shouldSetAsset(IAssetAdministrationShell shell) {
        return shell.getAsset() == null && shell.getAssetReference() != null;
    }

    private void setAsset(Collection<? extends IAsset> assets, IAssetAdministrationShell shell) {
        try {
            IReference assetRef = shell.getAssetReference();
            IAsset asset = this.getByReference(assetRef, assets);
            ((AssetAdministrationShell)shell).setAsset((Asset)asset);
        }
        catch (ResourceNotFoundException e) {
            if (shell.getAssetReference().getKeys().size() > 0) {
                logger.warn("Can't find asset with id " + shell.getAssetReference().getKeys().get(0).getValue() + " for AAS " + shell.getIdShort() + "; If the asset is not provided in another way, this is an error!");
            }
            logger.warn("Can't find asset for AAS " + shell.getIdShort() + "; If the asset is not provided in another way, this is an error!");
        }
    }

    private Set<ISubmodel> retrieveSubmodelsForAAS(Collection<? extends ISubmodel> submodels, IAssetAdministrationShell shell) {
        HashSet<ISubmodel> currentSM = new HashSet<ISubmodel>();
        for (IReference submodelRef : shell.getSubmodelReferences()) {
            try {
                ISubmodel sm = this.getByReference(submodelRef, submodels);
                currentSM.add(sm);
                logger.debug("Found Submodel " + sm.getIdShort() + " for AAS " + shell.getIdShort());
            }
            catch (ResourceNotFoundException e) {
                logger.warn("Could not find Submodel " + submodelRef.getKeys().get(0).getValue() + " for AAS " + shell.getIdShort() + "; If it is not hosted elsewhere this is an error!");
            }
        }
        return currentSM;
    }

    private <T extends IIdentifiable> T getByReference(IReference ref, Collection<T> identifiable) throws ResourceNotFoundException {
        IKey lastKey = null;
        Iterator<IKey> iterator = ref.getKeys().iterator();
        while (iterator.hasNext()) {
            IKey key;
            lastKey = key = iterator.next();
            Optional<IIdentifiable> match = identifiable.stream().filter(s -> s.getIdentification().getId().equals(key.getValue())).findFirst();
            if (!match.isPresent()) continue;
            return (T)match.get();
        }
        if (lastKey == null) {
            throw new ResourceNotFoundException("Could not resolve reference without keys");
        }
        throw new ResourceNotFoundException("Could not resolve reference with last key '" + lastKey.getValue() + "'");
    }
}

