/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.aasx;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.basyx.aas.factory.aasx.AASXToMetamodelConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoaderHelper {
    private static Logger logger = LoggerFactory.getLogger(FileLoaderHelper.class);

    public static InputStream getInputStream(String aasxFilePath) throws IOException {
        InputStream stream = FileLoaderHelper.getResourceStream(aasxFilePath);
        if (stream != null) {
            return stream;
        }
        try {
            return new FileInputStream(aasxFilePath);
        }
        catch (FileNotFoundException e) {
            logger.error("File '" + aasxFilePath + "' to be loaded was not found.");
            throw e;
        }
    }

    private static InputStream getResourceStream(String relativeResourcePath) {
        ClassLoader classLoader = AASXToMetamodelConverter.class.getClassLoader();
        return classLoader.getResourceAsStream(relativeResourcePath);
    }
}

