/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.authorization.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.registration.authorization.internal.IAASRegistryAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedAASRegistry<SubjectInformationType>
implements IAASRegistry {
    public static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-registry:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-registry:write";
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedAASRegistry.class);
    protected final IAASRegistry decoratedRegistry;
    protected final IAASRegistryAuthorizer<SubjectInformationType> aasRegistryAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedAASRegistry(IAASRegistry decoratedRegistry, IAASRegistryAuthorizer<SubjectInformationType> aasRegistryAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this.decoratedRegistry = decoratedRegistry;
        this.aasRegistryAuthorizer = aasRegistryAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedRegistry.register(deviceAASDescriptor);
            return;
        }
        try {
            this.authorizeRegister(deviceAASDescriptor);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedRegistry.register(deviceAASDescriptor);
    }

    protected void authorizeRegister(AASDescriptor aasDescriptor) throws InhibitException {
        this.aasRegistryAuthorizer.authorizeRegisterAas(this.subjectInformationProvider.get(), aasDescriptor);
    }

    @Override
    public void register(IIdentifier aasId, SubmodelDescriptor smDescriptor) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedRegistry.register(aasId, smDescriptor);
            return;
        }
        try {
            this.authorizeRegister(aasId, smDescriptor);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedRegistry.register(aasId, smDescriptor);
    }

    protected void authorizeRegister(IIdentifier aasId, SubmodelDescriptor smDescriptor) throws InhibitException {
        this.aasRegistryAuthorizer.authorizeRegisterSubmodel(this.subjectInformationProvider.get(), aasId, smDescriptor);
    }

    @Override
    public void delete(IIdentifier aasId) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedRegistry.delete(aasId);
            return;
        }
        try {
            this.authorizeDelete(aasId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedRegistry.delete(aasId);
    }

    protected void authorizeDelete(IIdentifier aasId) throws InhibitException {
        this.aasRegistryAuthorizer.authorizeUnregisterAas(this.subjectInformationProvider.get(), aasId);
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedRegistry.delete(aasId, smId);
            return;
        }
        try {
            this.authorizeDelete(aasId, smId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedRegistry.delete(aasId, smId);
    }

    protected void authorizeDelete(IIdentifier aasId, IIdentifier smId) throws InhibitException {
        this.aasRegistryAuthorizer.authorizeUnregisterSubmodel(this.subjectInformationProvider.get(), aasId, smId);
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasId) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedRegistry.lookupAAS(aasId);
        }
        try {
            return this.authorizeLookupAAS(aasId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected AASDescriptor authorizeLookupAAS(IIdentifier aasId) throws InhibitException {
        AASDescriptor authorizedAASDescriptor = this.authorizeAASDescriptorOnly(aasId);
        if (authorizedAASDescriptor == null) {
            throw new ResourceNotFoundException("AAS with Id " + aasId.getId() + " does not exist");
        }
        Collection submodelDescriptorsToRetain = authorizedAASDescriptor.getSubmodelDescriptors().stream().map(submodelDescriptor -> {
            IIdentifier smId = submodelDescriptor.getIdentifier();
            try {
                return this.authorizeLookupSubmodel(aasId, smId);
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return this.shallowCopyAndSubstituteSubmodels(authorizedAASDescriptor, submodelDescriptorsToRetain);
    }

    private AASDescriptor shallowCopyAndSubstituteSubmodels(AASDescriptor originalAASDescriptor, Collection<SubmodelDescriptor> newSubmodels) {
        AASDescriptor enforcedAASDescriptor = this.shallowCopyAASDescriptor(originalAASDescriptor);
        Collection<SubmodelDescriptor> originalSubmodelDescriptors = enforcedAASDescriptor.getSubmodelDescriptors();
        if (!originalSubmodelDescriptors.isEmpty()) {
            ArrayList<SubmodelDescriptor> enforcedSubmodelDescriptorList = new ArrayList<SubmodelDescriptor>(originalSubmodelDescriptors);
            enforcedSubmodelDescriptorList.retainAll(newSubmodels);
            enforcedAASDescriptor.put("submodels", enforcedSubmodelDescriptorList);
        }
        return enforcedAASDescriptor;
    }

    private AASDescriptor shallowCopyAASDescriptor(AASDescriptor originalAASDescriptor) {
        if (originalAASDescriptor instanceof TaggedAASDescriptor) {
            return TaggedAASDescriptor.createAsFacade(new HashMap<String, Object>(originalAASDescriptor));
        }
        return new AASDescriptor((Map<String, Object>)new HashMap<String, Object>(originalAASDescriptor));
    }

    private AASDescriptor authorizeAASDescriptorOnly(IIdentifier aasId) throws InhibitException {
        return this.aasRegistryAuthorizer.authorizeLookupAAS(this.subjectInformationProvider.get(), aasId, () -> this.decoratedRegistry.lookupAAS(aasId));
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedRegistry.lookupAll();
        }
        try {
            return this.authorizeLookupAll();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected List<AASDescriptor> authorizeLookupAll() throws InhibitException {
        return this.authorizeAASDescriptorListOnly().stream().map(aas -> {
            try {
                return this.authorizeLookupAAS(aas.getIdentifier());
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<AASDescriptor> authorizeAASDescriptorListOnly() throws InhibitException {
        return this.aasRegistryAuthorizer.authorizeLookupAll(this.subjectInformationProvider.get(), this.decoratedRegistry::lookupAll);
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedRegistry.lookupSubmodels(aasId);
        }
        try {
            return this.authorizeLookupSubmodels(aasId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected List<SubmodelDescriptor> authorizeLookupSubmodels(IIdentifier aasId) throws InhibitException {
        return this.authorizeSubmodelListOnly(aasId).stream().map(submodel -> {
            try {
                return this.authorizeLookupSubmodel(aasId, submodel.getIdentifier());
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<SubmodelDescriptor> authorizeSubmodelListOnly(IIdentifier aasId) throws InhibitException {
        return this.aasRegistryAuthorizer.authorizeLookupSubmodels(this.subjectInformationProvider.get(), aasId, () -> this.decoratedRegistry.lookupSubmodels(aasId));
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedRegistry.lookupSubmodel(aasId, smId);
        }
        try {
            return this.authorizeLookupSubmodel(aasId, smId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected SubmodelDescriptor authorizeLookupSubmodel(IIdentifier aasId, IIdentifier smId) throws InhibitException {
        return this.aasRegistryAuthorizer.authorizeLookupSubmodel(this.subjectInformationProvider.get(), aasId, smId, () -> this.decoratedRegistry.lookupSubmodel(aasId, smId));
    }
}

