/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRule;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSet;
import org.eclipse.basyx.extensions.shared.authorization.internal.TagTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.TargetInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacRuleSetDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(RbacRuleSetDeserializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RbacRuleSetDeserializer() {
        this(mapper -> {});
    }

    public RbacRuleSetDeserializer(Consumer<ObjectMapper> objectMapperConsumer) {
        this.objectMapper.addMixIn(RbacRule.class, RbacRuleMixin.class);
        this.objectMapper.addMixIn(TargetInformation.class, TargetInformationMixin.class).registerSubtypes(new NamedType[]{new NamedType(BaSyxObjectTargetInformation.class, "basyx"), new NamedType(TagTargetInformation.class, "tag")});
        objectMapperConsumer.accept(this.objectMapper);
    }

    public RbacRuleSet fromFile(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath must not be null");
        }
        logger.info("loading rbac rules...");
        try (InputStream inputStream = RbacRuleSet.class.getResourceAsStream(filePath);){
            if (inputStream == null) {
                throw new FileNotFoundException("could not find " + filePath);
            }
            Object[] rbacRules = this.deserialize(inputStream);
            logger.info("Read rbac rules: {}", (Object)Arrays.toString(rbacRules));
            RbacRuleSet rbacRuleSet = new RbacRuleSet();
            Arrays.stream(rbacRules).forEach(rbacRuleSet::addRule);
            RbacRuleSet rbacRuleSet2 = rbacRuleSet;
            return rbacRuleSet2;
        }
    }

    public RbacRule[] deserialize(InputStream inputStream) throws IOException {
        return (RbacRule[])this.objectMapper.readValue(inputStream, RbacRule[].class);
    }

    public static class RbacRuleMixin {
        @JsonCreator
        public RbacRuleMixin(@JsonProperty(value="role") String role, @JsonProperty(value="action") String action, @JsonProperty(value="targetInformation") TargetInformation targetInformation) {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    public static class TargetInformationMixin {
    }
}

