/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.qualifier.qualifiable;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasSemanticsXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IConstraint;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IFormula;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IQualifiable;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IQualifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasSemantics;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Formula;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifier;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QualifiableXMLConverter {
    private static Logger logger = LoggerFactory.getLogger(QualifiableXMLConverter.class);
    public static final String QUALIFIER = "aas:qualifier";
    public static final String FORMULA = "aas:formula";
    public static final String DEPENDS_ON_REFS = "aas:dependsOnRefs";
    public static final String REFERENCE = "aas:reference";
    public static final String TYPE = "aas:type";
    public static final String VALUE = "aas:value";
    public static final String VALUE_TYPE = "aas:valueType";
    public static final String VALUE_ID = "aas:valueId";

    public static void populateQualifiable(Map<String, Object> xmlObject, Qualifiable qualifiable) {
        Map qualifierObj = (Map)xmlObject.get(QUALIFIER);
        if (qualifierObj != null) {
            qualifiable.setQualifiers(QualifiableXMLConverter.parseConstraints(qualifierObj));
        }
    }

    private static Collection<IConstraint> parseConstraints(Map<String, Object> xmlConstraints) {
        HashSet<IConstraint> constraints = new HashSet<IConstraint>();
        if (xmlConstraints == null) {
            return constraints;
        }
        List<Map<String, Object>> xmlQualifier = XMLHelper.getList(xmlConstraints.get(QUALIFIER));
        xmlQualifier.stream().map(QualifiableXMLConverter::parseQualifier).forEach(constraints::add);
        List<Map<String, Object>> xmlFormula = XMLHelper.getList(xmlConstraints.get(FORMULA));
        xmlFormula.stream().map(QualifiableXMLConverter::parseFormula).forEach(constraints::add);
        return constraints;
    }

    private static Formula parseFormula(Map<String, Object> xmlFormula) {
        Map dependsOnObj = (Map)xmlFormula.get(DEPENDS_ON_REFS);
        HashSet<IReference> referenceList = new HashSet<IReference>();
        List<Map<String, Object>> xmlReferenceList = XMLHelper.getList(dependsOnObj.get(REFERENCE));
        for (Map<String, Object> xmlReference : xmlReferenceList) {
            referenceList.add(ReferenceXMLConverter.parseReference(xmlReference));
        }
        return new Formula(referenceList);
    }

    private static Qualifier parseQualifier(Map<String, Object> xmlQualifier) {
        String type = XMLHelper.getString(xmlQualifier.get(TYPE));
        String value = XMLHelper.getString(xmlQualifier.get(VALUE));
        String valueType = XMLHelper.getString(xmlQualifier.get(VALUE_TYPE));
        Map qualifierValueIdObj = (Map)xmlQualifier.get(VALUE_ID);
        Reference ref = ReferenceXMLConverter.parseReference(qualifierValueIdObj);
        Qualifier qualifier = new Qualifier();
        HasSemanticsXMLConverter.populateHasSemantics(xmlQualifier, HasSemantics.createAsFacade(qualifier));
        qualifier.setType(type);
        qualifier.setValue(value);
        qualifier.setValueId(ref);
        if (valueType == null || valueType.isEmpty()) {
            logger.warn("Creating element " + xmlQualifier + " without mandatory valueType!");
        } else {
            qualifier.setValueType(XMLHelper.convertAASXValueTypeToLocal(valueType));
        }
        return qualifier;
    }

    public static void populateQualifiableXML(Document document, Element root, IQualifiable qualifiable) {
        if (qualifiable.getQualifiers() == null || qualifiable.getQualifiers().size() == 0) {
            return;
        }
        Collection<IConstraint> constraints = qualifiable.getQualifiers();
        Element qualifierRoot = document.createElement(QUALIFIER);
        for (IConstraint constraint : constraints) {
            qualifierRoot.appendChild(QualifiableXMLConverter.buildQualifiersXML(document, constraint));
        }
        root.appendChild(qualifierRoot);
    }

    private static Element buildQualifiersXML(Document document, IConstraint constraint) {
        if (constraint instanceof IFormula) {
            return QualifiableXMLConverter.buildFormulaXML(document, (IFormula)constraint);
        }
        if (constraint instanceof IQualifier) {
            return QualifiableXMLConverter.buildQualifierXML(document, (IQualifier)constraint);
        }
        throw new RuntimeException("Unknown qualifier type " + constraint);
    }

    private static Element buildFormulaXML(Document document, IFormula formula) {
        Element formulaRoot = document.createElement(FORMULA);
        Element dependsOnRoot = document.createElement(DEPENDS_ON_REFS);
        Collection<IReference> ref = formula.getDependsOn();
        Element refrenceRoot = document.createElement(REFERENCE);
        refrenceRoot.appendChild(ReferenceXMLConverter.buildReferencesXML(document, ref));
        dependsOnRoot.appendChild(refrenceRoot);
        formulaRoot.appendChild(dependsOnRoot);
        return formulaRoot;
    }

    private static Element buildQualifierXML(Document document, IQualifier qualifier) {
        IReference qualId = qualifier.getValueId();
        String type = XMLHelper.getString(qualifier.getType());
        String value = XMLHelper.getString(qualifier.getValue());
        String valueType = qualifier.getValueType().toString();
        Element qualifierRoot = document.createElement(QUALIFIER);
        Element qualifierValueId = document.createElement(VALUE_ID);
        Element keysElement = ReferenceXMLConverter.buildReferenceXML(document, qualId);
        if (keysElement != null) {
            qualifierValueId.appendChild(keysElement);
        }
        qualifierRoot.appendChild(qualifierValueId);
        Element qualifierValue = document.createElement(VALUE);
        qualifierValue.appendChild(document.createTextNode(value));
        qualifierRoot.appendChild(qualifierValue);
        Element qualifierType = document.createElement(TYPE);
        qualifierType.appendChild(document.createTextNode(type));
        qualifierRoot.appendChild(qualifierType);
        Element qualifierValueType = document.createElement(VALUE_TYPE);
        qualifierValueType.appendChild(document.createTextNode(valueType));
        qualifierRoot.appendChild(qualifierValueType);
        HasSemanticsXMLConverter.populateHasSemanticsXML(document, qualifierRoot, qualifier);
        return qualifierRoot;
    }
}

