/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.operation;

import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IConstraint;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifier;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;

public class DelegatedInvocationManager {
    public static final String DELEGATION_TYPE = "invocationDelegation";
    private IConnectorFactory connectorFactory;

    public DelegatedInvocationManager(IConnectorFactory connectorFactory) {
        this.connectorFactory = connectorFactory;
    }

    public static boolean isDelegatingOperation(Operation operation) {
        return DelegatedInvocationManager.getDelegatedQualifier(operation) != null;
    }

    public Object invokeDelegatedOperation(Operation operation, Object ... parameters) {
        String delegatedUrl = DelegatedInvocationManager.getDelegatedURL(operation);
        return this.connectorFactory.create(delegatedUrl).invokeOperation("", parameters);
    }

    public static Qualifier createDelegationQualifier(String delegationURL) {
        return new Qualifier(DELEGATION_TYPE, delegationURL, ValueType.String, null);
    }

    private static String getDelegatedURL(Operation operation) throws RuntimeException {
        Qualifier qualifier = DelegatedInvocationManager.getDelegatedQualifier(operation);
        if (qualifier != null) {
            return qualifier.getValue().toString();
        }
        throw new RuntimeException("Qualifier with Delegated type does not exist");
    }

    private static Qualifier getDelegatedQualifier(Operation operation) {
        Collection<IConstraint> constraints = operation.getQualifiers();
        for (IConstraint constraint : constraints) {
            Qualifier qualifier = Qualifier.createAsFacade((Map)((Object)constraint));
            if (!DelegatedInvocationManager.isDelegationQualifier(qualifier)) continue;
            return qualifier;
        }
        return null;
    }

    private static boolean isDelegationQualifier(Qualifier qualifier) {
        return qualifier.getType() != null && qualifier.getType().equalsIgnoreCase(DELEGATION_TYPE);
    }
}

