/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAasDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.io.IOException;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.submodel.restapi.SubmodelProvider;

public abstract class BaSyxAbstractAasServer
implements AasServer {
    private DeploymentSpec deploymentSpec;

    public BaSyxAbstractAasServer(DeploymentSpec deploymentSpec) {
        this.deploymentSpec = deploymentSpec;
    }

    public void deploy(Aas aas) throws IOException {
        BaSyxDeploymentRecipe.deploy(this.deploymentSpec, aas);
    }

    public void deploy(Aas aas, Submodel submodel) {
        if (!(submodel instanceof BaSyxSubmodel)) {
            throw new IllegalArgumentException("The subModel must be of instance BaSyxSubModel, i.e., created through the AasFactory.");
        }
        BaSyxAasDescriptor desc = this.deploymentSpec.getDescriptor(aas.getIdShort());
        if (null == desc) {
            throw new IllegalArgumentException("The AAS " + aas.getIdShort() + " is unknown on this server instance.");
        }
        BaSyxSubmodel sm = (BaSyxSubmodel)submodel;
        SubmodelProvider subModelProvider = new SubmodelProvider((org.eclipse.basyx.submodel.metamodel.map.Submodel)sm.getSubmodel());
        desc.getFullProvider().addSubmodel(subModelProvider);
        desc.getAasDescriptor().addSubmodelDescriptor(new SubmodelDescriptor(sm.getSubmodel(), AbstractSubmodel.getSubmodelEndpoint((ServerAddress)this.deploymentSpec.getEndpoint(), aas, submodel)));
    }

    public void stop(boolean dispose) {
        if (dispose) {
            Tools.disposeTomcatWorkingDir(null, this.deploymentSpec.getEndpoint().getPort());
        }
    }
}

