/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.AasxPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.JsonPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.XmlPersistenceRecipe;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BaSyxPersistenceRecipe
implements PersistenceRecipe {
    private static final Map<FileFormat, PersistenceRecipe> RECIPES;

    BaSyxPersistenceRecipe() {
    }

    private PersistenceRecipe findMatching(File file) {
        PersistenceRecipe result = null;
        for (FileFormat ff : RECIPES.keySet()) {
            if (!ff.matches(file)) continue;
            result = RECIPES.get(ff);
        }
        if (null == result) {
            throw new IllegalArgumentException("Unrecognized file format for " + String.valueOf(file));
        }
        return result;
    }

    public void writeTo(List<Aas> aas, File thumbnail, List<PersistenceRecipe.FileResource> resources, File file) throws IOException {
        this.findMatching(file).writeTo(aas, thumbnail, resources, file);
    }

    public List<Aas> readFrom(File file) throws IOException {
        return this.findMatching(file).readFrom(file);
    }

    public Collection<FileFormat> getSupportedFormats() {
        return RECIPES.keySet();
    }

    static {
        PersistenceRecipe[] rcps;
        HashMap<FileFormat, PersistenceRecipe> recipes = new HashMap<FileFormat, PersistenceRecipe>();
        for (PersistenceRecipe r : rcps = new PersistenceRecipe[]{new XmlPersistenceRecipe(), new AasxPersistenceRecipe(), new JsonPersistenceRecipe()}) {
            for (FileFormat f : r.getSupportedFormats()) {
                recipes.put(f, r);
            }
        }
        RECIPES = Collections.unmodifiableMap(recipes);
    }
}

