/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.HashedUser;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5HashedNegotiator;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5HexNegotiator;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64MD5PasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<HashedUser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64MD5PasswordFilePrincipalDatabase.class);
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("CRAM-MD5-HASHED", "CRAM-MD5-HEX", "PLAIN"));

    public Base64MD5PasswordFilePrincipalDatabase(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider) {
        super(authenticationProvider);
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        byte[] md5byteArray;
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specified users password");
        }
        byte[] byteArray = new byte[password.length];
        int index = 0;
        for (char c : password) {
            byteArray[index++] = (byte)c;
        }
        try {
            md5byteArray = HashedUser.getMD5(byteArray);
        }
        catch (Exception e1) {
            this.getLogger().warn("Unable to hash password for user '{}' for comparison", (Object)principal);
            return false;
        }
        char[] hashedPassword = new char[md5byteArray.length];
        index = 0;
        for (byte c : md5byteArray) {
            hashedPassword[index++] = (char)c;
        }
        return this.compareCharArray(pwd, hashedPassword);
    }

    @Override
    protected HashedUser createUserFromPassword(Principal principal, char[] passwd) {
        return new HashedUser(principal.getName(), passwd, this.getAuthenticationProvider());
    }

    @Override
    protected HashedUser createUserFromFileData(String[] result) {
        return new HashedUser(result, this.getAuthenticationProvider());
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings) {
        if ("CRAM-MD5-HASHED".equals(mechanism)) {
            return new CramMd5HashedNegotiator(this.getAuthenticationProvider(), saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        if ("CRAM-MD5-HEX".equals(mechanism)) {
            return new CramMd5HexNegotiator(this.getAuthenticationProvider(), saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        if ("PLAIN".equals(mechanism)) {
            return new PlainNegotiator(this.getAuthenticationProvider());
        }
        return null;
    }
}

