/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.AuthenticationProviderMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationManager<T extends AbstractAuthenticationManager<T>>
extends AbstractConfiguredObject<T>
implements AuthenticationProvider<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthenticationManager.class);
    private final Container<?> _container;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private List<String> _secureOnlyMechanisms;
    @ManagedAttributeField
    private List<String> _disabledMechanisms;

    protected AbstractAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(container, attributes);
        this._container = container;
        this._eventLogger = this._container.getEventLogger();
    }

    @Override
    public void onValidate() {
        super.onValidate();
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @Override
    public List<String> getAvailableMechanisms(boolean secure) {
        HashSet<String> filter;
        List<String> mechanisms = this.getMechanisms();
        HashSet<String> hashSet = filter = this.getDisabledMechanisms() != null ? new HashSet<String>(this.getDisabledMechanisms()) : new HashSet();
        if (!secure) {
            filter.addAll(this.getSecureOnlyMechanisms());
        }
        if (!filter.isEmpty()) {
            mechanisms = new ArrayList<String>(mechanisms);
            mechanisms.removeAll(filter);
        }
        return mechanisms;
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    protected ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.QUIESCED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        try {
            this.setState(State.ACTIVE);
        }
        catch (RuntimeException e) {
            this.setState(State.ERRORED);
            if (this.getAncestor(SystemConfig.class).isManagementMode()) {
                LOGGER.warn("Failed to activate authentication provider: " + this.getName(), (Throwable)e);
            }
            throw e;
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public final List<String> getSecureOnlyMechanisms() {
        return this._secureOnlyMechanisms;
    }

    @Override
    public final List<String> getDisabledMechanisms() {
        return this._disabledMechanisms;
    }

    @Override
    protected void logOperation(String operation) {
        this._container.getEventLogger().message(AuthenticationProviderMessages.OPERATION(operation));
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this._eventLogger.message(AuthenticationProviderMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this._eventLogger.message(AuthenticationProviderMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this._eventLogger.message(AuthenticationProviderMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this._eventLogger.message(AuthenticationProviderMessages.UPDATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }
}

