/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.typedmessage;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.qpid.server.typedmessage.TypedBytesCodes;
import org.apache.qpid.server.typedmessage.TypedBytesFormatException;

public class TypedBytesContentWriter
implements TypedBytesCodes {
    private final ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private final DataOutputStream _data = new DataOutputStream(this._baos);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    protected void writeTypeDiscriminator(byte type) {
        try {
            this._data.writeByte(type);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    private RuntimeException handle(IOException e) {
        RuntimeException jmsEx = new RuntimeException("Unable to write value: " + e.getMessage());
        return jmsEx;
    }

    public void writeBoolean(boolean b) {
        this.writeTypeDiscriminator((byte)1);
        this.writeBooleanImpl(b);
    }

    public void writeBooleanImpl(boolean b) {
        try {
            this._data.writeByte(b ? 1 : 0);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeByte(byte b) {
        this.writeTypeDiscriminator((byte)2);
        this.writeByteImpl(b);
    }

    public void writeByteImpl(byte b) {
        try {
            this._data.writeByte(b);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeShort(short i) {
        this.writeTypeDiscriminator((byte)4);
        this.writeShortImpl(i);
    }

    public void writeShortImpl(short i) {
        try {
            this._data.writeShort(i);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeChar(char c) {
        this.writeTypeDiscriminator((byte)5);
        this.writeCharImpl(c);
    }

    public void writeCharImpl(char c) {
        try {
            this._data.writeChar(c);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeInt(int i) {
        this.writeTypeDiscriminator((byte)6);
        this.writeIntImpl(i);
    }

    public void writeIntImpl(int i) {
        try {
            this._data.writeInt(i);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeLong(long l) {
        this.writeTypeDiscriminator((byte)7);
        this.writeLongImpl(l);
    }

    public void writeLongImpl(long l) {
        try {
            this._data.writeLong(l);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeFloat(float v) {
        this.writeTypeDiscriminator((byte)8);
        this.writeFloatImpl(v);
    }

    public void writeFloatImpl(float v) {
        try {
            this._data.writeFloat(v);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeDouble(double v) {
        this.writeTypeDiscriminator((byte)9);
        this.writeDoubleImpl(v);
    }

    public void writeDoubleImpl(double v) {
        try {
            this._data.writeDouble(v);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeTypeDiscriminator((byte)11);
        } else {
            this.writeTypeDiscriminator((byte)10);
            this.writeNullTerminatedStringImpl(string);
        }
    }

    public void writeNullTerminatedStringImpl(String string) {
        try {
            this._data.write(string.getBytes(UTF8));
            this._data.writeByte(0);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes == null ? 0 : bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int length) {
        this.writeTypeDiscriminator((byte)3);
        this.writeBytesImpl(bytes, offset, length);
    }

    public void writeBytesImpl(byte[] bytes, int offset, int length) {
        try {
            if (bytes == null) {
                this._data.writeInt(-1);
            } else {
                this._data.writeInt(length);
                this._data.write(bytes, offset, length);
            }
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeBytesRaw(byte[] bytes, int offset, int length) {
        try {
            if (bytes != null) {
                this._data.write(bytes, offset, length);
            }
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeObject(Object object) throws TypedBytesFormatException {
        Class clazz = object == null ? String.class : object.getClass();
        if (clazz == Byte.class) {
            this.writeByte((Byte)object);
        } else if (clazz == Boolean.class) {
            this.writeBoolean((Boolean)object);
        } else if (clazz == byte[].class) {
            this.writeBytes((byte[])object);
        } else if (clazz == Short.class) {
            this.writeShort((Short)object);
        } else if (clazz == Character.class) {
            this.writeChar(((Character)object).charValue());
        } else if (clazz == Integer.class) {
            this.writeInt((Integer)object);
        } else if (clazz == Long.class) {
            this.writeLong((Long)object);
        } else if (clazz == Float.class) {
            this.writeFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            this.writeDouble((Double)object);
        } else if (clazz == String.class) {
            this.writeString((String)object);
        } else {
            throw new TypedBytesFormatException("Only primitives plus byte arrays and String are valid types");
        }
    }

    public ByteBuffer getData() {
        return ByteBuffer.wrap(this._baos.toByteArray());
    }

    public void writeLengthPrefixedUTF(String string) throws TypedBytesFormatException {
        try {
            CharsetEncoder encoder = UTF8.newEncoder();
            ByteBuffer encodedString = encoder.encode(CharBuffer.wrap(string));
            this.writeShortImpl((short)encodedString.limit());
            while (encodedString.hasRemaining()) {
                this._data.writeByte(encodedString.get());
            }
        }
        catch (CharacterCodingException e) {
            TypedBytesFormatException jmse = new TypedBytesFormatException("Unable to encode string: " + e);
            jmse.initCause(e);
            throw jmse;
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }
}

