/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.CorsEnabledRecipe;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.config.EndpointHolder;
import de.iip_ecosphere.platform.support.iip_aas.config.ProtocolAddressHolder;
import de.iip_ecosphere.platform.support.iip_aas.config.RuntimeSetupEndpointValidator;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AasPartRegistry {
    public static final String NAME_AAS = "IIP_Ecosphere";
    public static final String NAME_SUBMODEL_SERVICES = "services";
    public static final String NAME_COLLECTION_SERVICES = "services";
    public static final String NAME_SUBMODEL_RESOURCES = "resources";
    public static final String NAME_PROP_DEVICE_AAS = "deviceAas";
    public static final String NAME_SUBMODEL_TRANSPORT = "transport";
    public static final String NAME_SUBMODEL_PLATFORM = "platform";
    public static final String NAME_SUBMODEL_NETWORK_MGT = "netMgt";
    public static final String NAME_SUBMODEL_TYPES = "types";
    public static final String NAME_SUBMODEL_CONN_INSTALLED = "installedConnectors";
    public static final String NAME_SUBMODEL_CONN_ACTIVE = "activeConnectors";
    public static final String NAME_SUBMODEL_MONITORING = "Monitoring";
    public static final String NAME_SUBMODEL_CONFIGURATION = "Configuration";
    public static final String NAME_SUBMODEL_ARTIFACTS = "Artifacts";
    public static final String NAME_SUBMODEL_STATUS = "Status";
    public static final String NAME_SUBMODEL_APPINSTANCES = "ApplicationInstances";
    public static final String ID_PART_SERVICES = "SVC";
    public static final String ID_PART_RESOURCES = "RES";
    public static final String ID_PART_DEVICES = "DEV";
    public static final String ID_PART_TRANSPORT = "TP";
    public static final String ID_PART_PLATFORM = "PLATF";
    public static final String ID_PART_NETWORK = "NET";
    public static final String ID_PART_TECHNICAL_DATA = "TD";
    public static final String ID_PART_SW_NAMEPLATE = "SW";
    public static final String ID_PART_TYPES = "TYPES";
    public static final String ID_PART_CONN_INSTALLED = "CONN_I";
    public static final String ID_PART_CONN_ACTIVE = "CONN_A";
    public static final String ID_PART_MONITORING = "MON";
    public static final String ID_PART_CONFIGURATION = "CFG";
    public static final String ID_PART_ARTIFACTS = "ARTS";
    public static final String ID_PART_STATUS = "STS";
    public static final String ID_PART_APPINSTANCES = "APPI";
    public static final String URN_AAS = "urn:::AAS:::iipEcosphere#";
    public static final String URN_AAS_ASSET = "urn:::AAS:::iipEcosphere#asset";
    public static final Schema DEFAULT_SCHEMA = Schema.HTTP;
    public static final String DEFAULT_HOST = "localhost";
    public static final String NO_SPECIFIC_SERVER_HOST = "-";
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_SM_PORT = 8082;
    public static final int DEFAULT_REGISTRY_PORT = 8081;
    public static final int DEFAULT_SM_REGISTRY_PORT = 8083;
    public static final int DEFAULT_PROTOCOL_PORT = 9000;
    public static final String DEFAULT_AAS_ENDPOINT = "";
    public static final String DEFAULT_REGISTRY_ENDPOINT = "registry";
    public static final String DEFAULT_PROTOCOL = "";
    private static AasSetup setup = new AasSetup();
    private static Supplier<List<Aas>> aasSupplier;
    private static int aasImplPort;
    private static Map<String, String> idShortIdentificationMapping;

    private static boolean ignoreAasUrlPaths() {
        return !AasFactory.getInstance().supportsUrlPaths();
    }

    private static EndpointHolder createAasEndpointHolder(Schema schema, String host, int port, String path) {
        return new EndpointHolder(schema, host, port, path).ignorePath(AasPartRegistry.ignoreAasUrlPaths());
    }

    private static EndpointHolder createAasEndpointHolder(EndpointHolder holder) {
        return new EndpointHolder(holder).ignorePath(AasPartRegistry.ignoreAasUrlPaths());
    }

    public static String getSubmodelIdentification(String idShort) {
        String id = idShortIdentificationMapping.get(idShort);
        return null == id ? null : AasPartRegistry.composeIdentifier(id);
    }

    public static Submodel.SubmodelBuilder createSubmodelBuilder(Aas.AasBuilder aasBuilder, String idShort) {
        return aasBuilder.createSubmodelBuilder(idShort, AasPartRegistry.getSubmodelIdentification(idShort));
    }

    public static Submodel.SubmodelBuilder createSubmodelBuilder(Aas aas, String idShort) {
        return aas.createSubmodelBuilder(idShort, AasPartRegistry.getSubmodelIdentification(idShort));
    }

    public static Submodel.SubmodelBuilder createSubmodelBuilderRbac(Aas.AasBuilder aasBuilder, String idShort) {
        return (Submodel.SubmodelBuilder)AasPartRegistry.createSubmodelBuilder(aasBuilder, idShort).rbacPlatform(AasPartRegistry.getSubmodelAuthentication());
    }

    public static Submodel.SubmodelBuilder createSubmodelBuilderRbac(Aas aas, String idShort) {
        return (Submodel.SubmodelBuilder)AasPartRegistry.createSubmodelBuilder(aas, idShort).rbacPlatform(AasPartRegistry.getSubmodelAuthentication());
    }

    public static void setAasSupplier(Supplier<List<Aas>> supplier) {
        aasSupplier = supplier;
    }

    public static AasSetup getSetup() {
        return setup;
    }

    public static AasSetup setAasSetup(AasSetup aasSetup) {
        return AasPartRegistry.setAasSetup(aasSetup, false);
    }

    public static AasSetup setAasSetup(AasSetup aasSetup, boolean resetImplPort) {
        AasSetup old = aasSetup;
        setup = aasSetup;
        AasFactory.setPluginId((String)setup.getPluginId());
        if (resetImplPort) {
            aasImplPort = -1;
        }
        return old;
    }

    private static ServiceLoader<AasContributor> getContributorLoader() {
        return ServiceLoader.load(AasContributor.class);
    }

    public static Iterator<AasContributor> contributors() {
        return AasPartRegistry.getContributorLoader().iterator();
    }

    public static Set<Class<? extends AasContributor>> contributorClasses() {
        HashSet<Class<? extends AasContributor>> result = new HashSet<Class<? extends AasContributor>>();
        Iterator<AasContributor> iter = AasPartRegistry.contributors();
        while (iter.hasNext()) {
            result.add(iter.next().getClass());
        }
        return result;
    }

    public static AasBuildResult build() {
        return AasPartRegistry.build(c -> true, false);
    }

    public static AasBuildResult build(boolean startImplServer) {
        return AasPartRegistry.build(c -> true, startImplServer);
    }

    public static AasBuildResult build(Predicate<AasContributor> filter) {
        return AasPartRegistry.build(filter, false);
    }

    public static AasBuildResult build(Predicate<AasContributor> filter, boolean startImplServer) {
        return AasPartRegistry.build(filter, startImplServer, null);
    }

    public static AasBuildResult build(Predicate<AasContributor> filter, boolean startImplServer, ProtocolServerBuilder sBuilder) {
        String implHost;
        Aas.AasBuilder aasBuilder;
        ArrayList<Aas> aas = new ArrayList<Aas>();
        AasFactory factory = AasFactory.getInstance();
        try {
            aasBuilder = AasPartRegistry.retrieveIipAas().createAasBuilder();
            aasBuilder.rbacAll(AasPartRegistry.getAasAuthentication());
        }
        catch (IOException e) {
            aasBuilder = factory.createAasBuilder(NAME_AAS, URN_AAS);
            aasBuilder.createAssetInformationBuilder(NAME_AAS, URN_AAS_ASSET, AssetKind.INSTANCE).build();
        }
        ProtocolAddressHolder impl = setup.getImplementation();
        if (aasImplPort < 0) {
            aasImplPort = ServerAddress.validatePort((int)impl.getPort());
        }
        if ((implHost = impl.getHost()).equals("127.0.0.1")) {
            implHost = NetUtils.getOwnIP((String)NetUtils.getNetMask((String)impl.getNetmask(), (String)impl.getHost()));
        }
        impl.setHost(implHost);
        LoggerFactory.getLogger(AasPartRegistry.class).info("Using {}:{} for AAS implementation server", (Object)implHost, (Object)aasImplPort);
        setup.getImplementation().setPort(aasImplPort);
        InvocablesCreator iCreator = factory.createInvocablesCreator((SetupSpec)setup);
        if (null == sBuilder) {
            sBuilder = factory.createProtocolServerBuilder((SetupSpec)setup);
        }
        Iterator<AasContributor> iter = AasPartRegistry.contributors();
        while (iter.hasNext()) {
            AasContributor contributor = iter.next();
            if (!filter.test(contributor) || !contributor.isValid()) continue;
            Aas partAas = contributor.contributeTo(aasBuilder, iCreator);
            contributor.contributeTo(sBuilder);
            if (null == partAas) continue;
            aas.add(partAas);
        }
        Server protocolServer = null;
        if (startImplServer) {
            LoggerFactory.getLogger(AasPartRegistry.class).info("Starting AAS implementation server on {}:{}", (Object)implHost, (Object)aasImplPort);
            protocolServer = ((Server)sBuilder.build()).start();
        }
        aas.add(0, (Aas)aasBuilder.build());
        return new AasBuildResult(aas, sBuilder, protocolServer);
    }

    public static Aas retrieveIipAas() throws IOException {
        return AasPartRegistry.retrieveAas(URN_AAS);
    }

    public static Aas retrieveAas(String identifier) throws IOException {
        return AasPartRegistry.retrieveAas(setup, identifier);
    }

    public static Aas retrieveAas(AasSetup setup, String identifier) throws IOException {
        return AasPartRegistry.retrieveAas(setup, identifier, true);
    }

    public static Aas retrieveAas(AasSetup setup, String identifier, boolean populate) throws IOException {
        Registry reg = AasFactory.getInstance().obtainRegistry((SetupSpec)setup, setup.getServer().getSchema());
        if (null == reg) {
            throw new IOException("No AAS registry at " + setup.getRegistryEndpoint().toUri());
        }
        try {
            return AasFactory.getInstance().obtainRegistry((SetupSpec)setup).retrieveAas(identifier, populate);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public static List<Aas> getIipAasInstance() {
        return null != aasSupplier ? aasSupplier.get() : null;
    }

    public static Server deploy(List<Aas> aas, String ... options) {
        DeploymentRecipe.ImmediateDeploymentRecipe dBuilder = AasPartRegistry.applyCorsOrigin(AasFactory.getInstance().createDeploymentRecipe((SetupSpec)setup), setup).forRegistry();
        for (Aas a : aas) {
            try {
                dBuilder.deploy(a);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(AasPartRegistry.class).error("Cannot deploy '{}': {}", (Object)a.getIdShort(), (Object)e.getMessage());
            }
        }
        return dBuilder.createServer(options);
    }

    public static <T extends CorsEnabledRecipe> T applyCorsOrigin(T rcp, AasSetup setup) {
        String acao = setup.getAccessControlAllowOrigin();
        if (null != acao && acao.length() > 0) {
            rcp.setAccessControlAllowOrigin(acao);
        }
        return rcp;
    }

    public static Server register(List<Aas> aas, Endpoint registry, String ... options) throws IOException {
        DeploymentRecipe.RegistryDeploymentRecipe dBuilder = AasPartRegistry.applyCorsOrigin(AasFactory.getInstance().createDeploymentRecipe((SetupSpec)setup), setup).forRegistry(registry);
        Registry reg = dBuilder.obtainRegistry();
        for (Aas a : aas) {
            for (Submodel s : a.submodels()) {
                reg.register(a, s, null);
            }
        }
        return dBuilder.createServer(options);
    }

    public static void remoteDeploy(List<Aas> aas) throws IOException {
        AasPartRegistry.remoteDeploy(setup, aas);
    }

    public static void remoteDeploy(AasSetup setup, List<Aas> aas) throws IOException {
        Endpoint aasEndpoint = setup.getServerEndpoint();
        DeploymentRecipe.RegistryDeploymentRecipe regD = AasPartRegistry.applyCorsOrigin(AasFactory.getInstance().createDeploymentRecipe((SetupSpec)setup), setup).forRegistry(setup.getRegistryEndpoint());
        Registry reg = regD.obtainRegistry();
        for (Aas a : aas) {
            try {
                reg.createAas(a, aasEndpoint.toServerUri());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (Submodel s : a.submodels()) {
                try {
                    reg.createSubmodel(a, s);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public static Aas getAas(List<Aas> list, String idShort) {
        return list.stream().filter(a -> a.getIdShort().equals(idShort)).findFirst().orElse(null);
    }

    public static Registry getIipAasRegistry() {
        Registry reg = null;
        try {
            reg = AasFactory.getInstance().obtainRegistry((SetupSpec)AasPartRegistry.getSetup());
        }
        catch (IOException e) {
            LoggerFactory.getLogger(AasPartRegistry.class).error("Obtaining AAS registry: {}. AAS linking disabled.", (Object)e.getMessage());
        }
        return reg;
    }

    private static Property addAasEndpointProperty(Registry reg, SubmodelElementContainerBuilder builder, String property, String aasId) {
        String ep;
        String string = ep = null == reg ? null : reg.getEndpoint(AasUtils.fixId((String)aasId));
        if (null == ep) {
            ep = "";
        }
        return (Property)builder.createPropertyBuilder(property).setValue(Type.STRING, (Object)ep).build();
    }

    public static Property addServiceAasEndpointProperty(Registry reg, SubmodelElementContainerBuilder builder, String property, String serviceId) {
        return AasPartRegistry.addAasEndpointProperty(reg, builder, property, (String)(serviceId.length() == 0 ? "" : "service_" + serviceId));
    }

    public static Property addDeviceAasEndpointProperty(Registry reg, SubmodelElementContainerBuilder builder, String property, String deviceId) {
        return AasPartRegistry.addAasEndpointProperty(reg, builder, property, (String)(deviceId.length() == 0 ? "" : "device_" + deviceId));
    }

    public static AuthenticationDescriptor getAasAuthentication() {
        return AasPartRegistry.getSetup().getSetup(SetupSpec.AasComponent.AAS_REPOSITORY).getAuthentication();
    }

    public static AuthenticationDescriptor getSubmodelAuthentication() {
        return AasPartRegistry.getSetup().getSetup(SetupSpec.AasComponent.SUBMODEL_REPOSITORY).getAuthentication();
    }

    public static String composeIdentifier(String specificId) {
        return AasUtils.composeIdentifier((String)URN_AAS, (String)specificId);
    }

    static {
        aasImplPort = -1;
        idShortIdentificationMapping = new HashMap<String, String>();
        idShortIdentificationMapping.put("services", ID_PART_SERVICES);
        idShortIdentificationMapping.put(NAME_SUBMODEL_RESOURCES, ID_PART_RESOURCES);
        idShortIdentificationMapping.put(NAME_SUBMODEL_TRANSPORT, ID_PART_TRANSPORT);
        idShortIdentificationMapping.put(NAME_SUBMODEL_PLATFORM, ID_PART_PLATFORM);
        idShortIdentificationMapping.put(NAME_SUBMODEL_NETWORK_MGT, ID_PART_NETWORK);
        idShortIdentificationMapping.put(NAME_SUBMODEL_TYPES, ID_PART_TYPES);
        idShortIdentificationMapping.put(NAME_SUBMODEL_CONN_INSTALLED, ID_PART_CONN_INSTALLED);
        idShortIdentificationMapping.put(NAME_SUBMODEL_CONN_ACTIVE, ID_PART_CONN_ACTIVE);
        idShortIdentificationMapping.put(NAME_SUBMODEL_MONITORING, ID_PART_MONITORING);
        idShortIdentificationMapping.put(NAME_SUBMODEL_CONFIGURATION, ID_PART_CONFIGURATION);
        idShortIdentificationMapping.put(NAME_SUBMODEL_ARTIFACTS, ID_PART_ARTIFACTS);
        idShortIdentificationMapping.put(NAME_SUBMODEL_STATUS, ID_PART_STATUS);
        idShortIdentificationMapping.put(NAME_SUBMODEL_APPINSTANCES, ID_PART_APPINSTANCES);
    }

    public static class AasSetup
    implements SetupSpec {
        private EndpointHolder server = AasPartRegistry.createAasEndpointHolder(DEFAULT_SCHEMA, "localhost", 8080, "");
        private EndpointHolder smServer = AasPartRegistry.createAasEndpointHolder(DEFAULT_SCHEMA, "localhost", 8082, "");
        private EndpointHolder registry = AasPartRegistry.createAasEndpointHolder(DEFAULT_SCHEMA, "localhost", 8081, "registry");
        private EndpointHolder smRegistry = AasPartRegistry.createAasEndpointHolder(DEFAULT_SCHEMA, "localhost", 8083, "registry");
        private ProtocolAddressHolder implementation = new ProtocolAddressHolder(Schema.IGNORE, "localhost", 9000, "");
        private String serverHost = "-";
        private AasMode mode = AasMode.REMOTE_DEPLOY;
        private String accessControlAllowOrigin;
        private int aasStartupTimeout = 120000;
        private String pluginId;
        private Map<SetupSpec.AasComponent, SetupSpec.ComponentSetup> setups = new HashMap<SetupSpec.AasComponent, SetupSpec.ComponentSetup>();

        public AasSetup() {
            this.setups.put(SetupSpec.AasComponent.AAS_REGISTRY, new WrappingComponentSetup(() -> this.registry));
            this.setups.put(SetupSpec.AasComponent.AAS_REPOSITORY, new WrappingComponentSetup(() -> this.server));
            this.setups.put(SetupSpec.AasComponent.SUBMODEL_REGISTRY, new WrappingComponentSetup(() -> this.smRegistry));
            this.setups.put(SetupSpec.AasComponent.SUBMODEL_REPOSITORY, new WrappingComponentSetup(() -> this.smServer));
            this.setups.put(SetupSpec.AasComponent.ASSET, new SetupSpec.ComponentSetup(this){
                private SetupSpec.State state = SetupSpec.State.STOPPED;
                final /* synthetic */ AasSetup this$0;
                {
                    this.this$0 = this$0;
                }

                public ServerAddress getServerAddress() {
                    return this.this$0.implementation.getServerAddress();
                }

                public Endpoint getEndpoint() {
                    return new Endpoint(this.this$0.implementation.getServerAddress(), "");
                }

                public KeyStoreDescriptor getKeyStore() {
                    return this.this$0.implementation.getKeystoreDescriptor();
                }

                public AuthenticationDescriptor getAuthentication() {
                    return null;
                }

                public SetupSpec.State getState() {
                    return this.this$0.isRunning(this.this$0.implementation, this.state);
                }

                public void notifyStateChange(SetupSpec.State state) {
                    this.state = state;
                }
            });
        }

        public AasSetup(AasSetup setup) {
            this.setups.put(SetupSpec.AasComponent.AAS_REGISTRY, new WrappingComponentSetup(() -> this.registry));
            this.setups.put(SetupSpec.AasComponent.AAS_REPOSITORY, new WrappingComponentSetup(() -> this.server));
            this.setups.put(SetupSpec.AasComponent.SUBMODEL_REGISTRY, new WrappingComponentSetup(() -> this.smRegistry));
            this.setups.put(SetupSpec.AasComponent.SUBMODEL_REPOSITORY, new WrappingComponentSetup(() -> this.smServer));
            this.setups.put(SetupSpec.AasComponent.ASSET, new /* invalid duplicate definition of identical inner class */);
            this.setServer(setup.server);
            this.setSubmodelServer(setup.smServer);
            this.setRegistry(setup.registry);
            this.setSubmodelRegistry(setup.smRegistry);
            this.setImplementation(setup.implementation);
            this.setMode(setup.mode);
        }

        @JsonIgnore
        public Endpoint getServerEndpoint() {
            return this.server.getEndpoint();
        }

        @JsonIgnore
        public Endpoint getRegistryEndpoint() {
            return this.registry.getEndpoint();
        }

        @JsonIgnore
        public ServerAddress getImplementationServer() {
            return this.implementation.getServerAddress();
        }

        @JsonIgnore
        public String getImplementationProtocol() {
            return this.implementation.getProtocol();
        }

        public EndpointHolder getServer() {
            return this.server;
        }

        public EndpointHolder getSubmodelServer() {
            return this.smServer;
        }

        public void setServer(EndpointHolder aas) {
            this.server = AasPartRegistry.createAasEndpointHolder(aas);
            this.server.setValidator(RuntimeSetupEndpointValidator.create(r -> r.getAasServer()));
        }

        public void setSubmodelServer(EndpointHolder aas) {
            this.smServer = AasPartRegistry.createAasEndpointHolder(aas);
            this.smServer.setValidator(RuntimeSetupEndpointValidator.create(r -> r.getSubmodelServer(), false));
        }

        public EndpointHolder getRegistry() {
            return this.registry;
        }

        public EndpointHolder getSubmodelRegistry() {
            return this.smRegistry;
        }

        public AasMode getMode() {
            return this.mode;
        }

        public int getAasStartupTimeout() {
            return this.aasStartupTimeout;
        }

        public void setAasStartupTimeout(int aasStartupTimeout) {
            this.aasStartupTimeout = aasStartupTimeout;
        }

        public void setMode(AasMode mode) {
            this.mode = mode;
        }

        public String getServerHost() {
            return this.serverHost;
        }

        public Endpoint adaptEndpoint(Endpoint endpoint) {
            Endpoint result = AasPartRegistry.NO_SPECIFIC_SERVER_HOST.equals(this.serverHost) ? endpoint : new Endpoint(endpoint.getSchema(), this.serverHost, endpoint.getPort(), endpoint.getEndpoint());
            return result;
        }

        public void setServerHost(String serverHost) {
            this.serverHost = serverHost;
        }

        public void setRegistry(EndpointHolder registry) {
            this.registry = AasPartRegistry.createAasEndpointHolder(registry);
            this.registry.setValidator(RuntimeSetupEndpointValidator.create(r -> r.getAasRegistry()));
        }

        public void setSubmodelRegistry(EndpointHolder registry) {
            this.smRegistry = AasPartRegistry.createAasEndpointHolder(registry);
            this.smRegistry.setValidator(RuntimeSetupEndpointValidator.create(r -> r.getSubmodelRegistry(), false));
        }

        public ProtocolAddressHolder getImplementation() {
            return this.implementation;
        }

        public void setImplementation(ProtocolAddressHolder implementation) {
            this.implementation = implementation;
        }

        public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
        }

        public String getAccessControlAllowOrigin() {
            return this.accessControlAllowOrigin;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        @JsonIgnore
        public static AasSetup createLocalEphemeralSetup() {
            return AasSetup.createLocalEphemeralSetup(null, true);
        }

        @JsonIgnore
        public static AasSetup createLocalEphemeralSetup(AasSetup setup, boolean regPortSame) {
            return AasSetup.createLocalEphemeralSetup(setup, regPortSame, () -> new AasSetup());
        }

        @JsonIgnore
        public static <A extends AasSetup> A createLocalEphemeralSetup(A setup, boolean regPortSame, Supplier<A> supplier) {
            Object result = setup;
            if (null == result) {
                result = (AasSetup)supplier.get();
            }
            if (regPortSame) {
                regPortSame = AasFactory.getInstance().supportsSamePorts();
            }
            result.getServer().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getServer().setPort(NetUtils.getEphemeralPort());
            result.getSubmodelServer().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getSubmodelServer().setPort(NetUtils.getEphemeralPort());
            result.getRegistry().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getRegistry().setPort(regPortSame ? result.getServer().getPort() : NetUtils.getEphemeralPort());
            result.getSubmodelRegistry().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getSubmodelRegistry().setPort(regPortSame ? result.getServer().getPort() : NetUtils.getEphemeralPort());
            result.getImplementation().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getImplementation().setPort(NetUtils.getEphemeralPort());
            return result;
        }

        @JsonIgnore
        public String getAssetServerProtocol() {
            return this.implementation.getProtocol();
        }

        private SetupSpec.State isRunning(ServerAddressHolder holder, SetupSpec.State state) {
            SetupSpec.State result = state;
            if (state == SetupSpec.State.STOPPED && holder.isRunning()) {
                result = SetupSpec.State.EXTERNAL;
            }
            return result;
        }

        @JsonIgnore
        public SetupSpec.ComponentSetup getSetup(SetupSpec.AasComponent component) {
            return this.setups.get(component);
        }

        private class WrappingComponentSetup
        implements SetupSpec.ComponentSetup {
            private Supplier<EndpointHolder> endpoint;
            private SetupSpec.State state = SetupSpec.State.STOPPED;

            private WrappingComponentSetup(Supplier<EndpointHolder> endpoint) {
                this.endpoint = endpoint;
            }

            public Endpoint getEndpoint() {
                return this.endpoint.get().getEndpoint();
            }

            public KeyStoreDescriptor getKeyStore() {
                return this.endpoint.get().getKeystoreDescriptor();
            }

            public AuthenticationDescriptor getAuthentication() {
                return this.endpoint.get().getAuthentication();
            }

            public SetupSpec.State getState() {
                return AasSetup.this.isRunning(this.endpoint.get(), this.state);
            }

            public void notifyStateChange(SetupSpec.State state) {
                this.state = state;
            }
        }
    }

    public static class AasBuildResult {
        private List<Aas> aas;
        private ProtocolServerBuilder sBuilder;
        private Server protocolServer;

        private AasBuildResult(List<Aas> aas, ProtocolServerBuilder sBuilder, Server protocolServer) {
            this.aas = aas;
            this.sBuilder = sBuilder;
            this.protocolServer = protocolServer;
        }

        public List<Aas> getAas() {
            return this.aas;
        }

        public ProtocolServerBuilder getProtocolServerBuilder() {
            return this.sBuilder;
        }

        public Server getProtocolServer() {
            return this.protocolServer;
        }

        public void stopProtocolServer(boolean dispose) {
            if (null != this.protocolServer) {
                this.protocolServer.stop(dispose);
            }
        }
    }

    public static enum AasMode {
        REMOTE_DEPLOY,
        REGISTER;

    }
}

