/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;

public interface JDBCConnectionProviderFactory
extends Pluggable {
    public String getType();

    public ConnectionProvider getConnectionProvider(String var1, String var2, String var3, Map<String, String> var4) throws SQLException;

    public Set<String> getProviderAttributeNames();

    public static final class FACTORIES {
        private FACTORIES() {
        }

        public static JDBCConnectionProviderFactory get(String type) {
            QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
            Iterable factories = qpidServiceLoader.atLeastOneInstanceOf(JDBCConnectionProviderFactory.class);
            for (JDBCConnectionProviderFactory factory : factories) {
                if (!factory.getType().equals(type)) continue;
                return factory;
            }
            return null;
        }
    }
}

