/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Test;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.MasterK8SAas;

public class MasterAasJavaK8SProxy {
    private static int vabPort = 7711;
    private static int aasPort = 8811;
    private static String serverIP = "Empty";
    private static String serverPort = "6443";
    private static boolean tlsCheck = false;

    public static String getServerIP() {
        return serverIP;
    }

    public static void setServerIP(String serverIP) {
        MasterAasJavaK8SProxy.serverIP = serverIP;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static void setServerPort(String serverPort) {
        MasterAasJavaK8SProxy.serverPort = serverPort;
    }

    public int getVabPort() {
        return vabPort;
    }

    public void setVabPort(int vabPort) {
        MasterAasJavaK8SProxy.vabPort = vabPort;
    }

    public int getAasPort() {
        return aasPort;
    }

    public void setAasPort(int aasPort) {
        MasterAasJavaK8SProxy.aasPort = aasPort;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            serverIP = args[0];
            System.out.println("Api Server IP:" + serverIP);
        } else {
            System.out.println("No Api Server IP passed");
        }
        if (args.length > 1) {
            tlsCheck = Boolean.parseBoolean(args[1]);
            if (tlsCheck) {
                System.out.println("Security option Enabled");
            } else {
                System.out.println("Security option Disabled");
            }
        } else {
            System.out.println("No security option passed, default false");
        }
        if (new File("/tmp/EndServerRun.k8s").exists()) {
            System.out.println("/tmp/EndServerRun.k8s is exist and stop the Client");
            return;
        }
        ArrayList<Server> servers = null;
        MasterK8SAas aas = new MasterK8SAas(serverIP, serverPort, vabPort, aasPort, tlsCheck);
        try {
            servers = tlsCheck ? aas.startLocalTLSAas() : aas.startLocalAas();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (true) {
            if (new File("/tmp/EndServerRun.k8s").exists()) {
                for (Server server : servers) {
                    server.stop(true);
                }
                break;
            }
            TimeUtils.sleep((int)1);
        }
    }

    @Test(timeout=120000L)
    public void mainTest() {
        tlsCheck = Boolean.valueOf(System.getProperty("tlsCheck"));
        MasterK8SAas aas = new MasterK8SAas(serverIP, serverPort, vabPort, aasPort, tlsCheck);
        try {
            if (tlsCheck) {
                aas.startLocalTLSAas();
            } else {
                aas.startLocalAas();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (true) {
            TimeUtils.sleep((int)1);
        }
    }
}

