/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.AbstractK8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutionException;
import okhttp3.Response;
import org.apache.http.client.ClientProtocolException;

public class AasK8SJavaProxy
extends AbstractK8SJavaProxy {
    private Submodel submodel;
    private Aas aas;
    private Submodel watchSubmodel;
    private Aas watchAas;

    public AasK8SJavaProxy(ProxyType proxyType, int aasPort, String serverIP, String serverPort, boolean tlsCheck) {
        super(proxyType, AasK8SJavaProxy.getServerAddress(proxyType, serverIP, serverPort, tlsCheck));
        if (proxyType.equals((Object)ProxyType.WorkerProxy)) {
            ServerAddress aasServer = new ServerAddress(Schema.HTTP, serverIP, Integer.parseInt(serverPort));
            Endpoint aasServerRegistry = new Endpoint(aasServer, "registry");
            BasicSetupSpec spec = new BasicSetupSpec(aasServerRegistry, aasServer);
            AasFactory factory = AasFactory.getInstance();
            try {
                this.aas = tlsCheck ? factory.obtainRegistry((SetupSpec)spec, Schema.HTTPS).retrieveAas("urn:::AAS:::MasterK8SAas#") : factory.obtainRegistry((SetupSpec)spec).retrieveAas("urn:::AAS:::MasterK8SAas#");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.submodel = this.aas.getSubmodel("MasterK8SAasService");
            AasFactory watchFactory = AasFactory.getInstance();
            try {
                this.watchAas = tlsCheck ? watchFactory.obtainRegistry((SetupSpec)spec, Schema.HTTPS).retrieveAas("urn:::AAS:::MasterK8SAas#") : watchFactory.obtainRegistry((SetupSpec)spec).retrieveAas("urn:::AAS:::MasterK8SAas#");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.watchSubmodel = this.watchAas.getSubmodel("MasterK8SAasService");
        }
    }

    @Override
    public byte[] sendK8SRequest(BufferedOutputStream writer, K8SRequest request) throws IOException {
        byte[] response = null;
        response = this.getProxyType() == ProxyType.MasterProxy ? this.executeK8SJavaClientRequest(writer, request) : this.executeK8SGet(writer, request);
        return response;
    }

    @Override
    public byte[] executeK8SGet(BufferedOutputStream writer, K8SRequest request) throws ClientProtocolException, IOException {
        String response = null;
        try {
            if (request.getPath().contains("&watch=true")) {
                Operation operation = this.watchSubmodel.getOperation("sendWatchToK8S");
                String requestBase64String = request.convertToBase64StringWithID();
                response = (String)operation.invoke(new Object[]{requestBase64String});
                byte[] responseByte = request.convertBase64StringToByte(response);
                String responseString = new String(responseByte);
                while (!responseString.contains("0\r\n\r\n")) {
                    writer.write(responseByte);
                    writer.flush();
                    response = (String)operation.invoke(new Object[]{requestBase64String});
                    responseByte = request.convertBase64StringToByte(response);
                    responseString = new String(responseByte);
                }
            } else {
                Operation operation = this.submodel.getOperation("sendToK8S");
                response = (String)operation.invoke(new Object[]{request.convertToBase64String()});
            }
        }
        catch (IOException | ExecutionException e) {
            e.printStackTrace();
        }
        return request.convertBase64StringToByte(response);
    }

    @Override
    public byte[] executeK8SPost(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    @Override
    public byte[] executeK8SPut(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    @Override
    public byte[] executeK8SPatch(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    @Override
    public byte[] executeK8SDelete(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatWatchK8SResponse(BufferedWriter writer, K8SRequest request, Response response) throws IOException {
        Object responseBody = "";
        Object formattedResponse = request.getProtocol() + " " + response.code() + " " + response.message() + "\r\n" + response.headers().toString();
        try {
            if (!response.body().source().exhausted()) {
                responseBody = response.body().source().readUtf8Line() + "\r\n";
                responseBody = Integer.toHexString(((String)responseBody).length()) + "\r\n" + (String)responseBody + "\r\n";
                formattedResponse = (String)formattedResponse + "\r\n" + (String)responseBody;
                writer.write((String)formattedResponse);
                writer.flush();
            }
            while (!response.body().source().exhausted()) {
                responseBody = response.body().source().readUtf8Line() + "\r\n";
                responseBody = Integer.toHexString(((String)responseBody).length()) + "\r\n" + (String)responseBody + "\r\n";
                writer.write((String)responseBody);
                writer.flush();
            }
        }
        catch (SocketTimeoutException e) {
            if (e.getMessage().contentEquals("timeout") || e.getMessage().contentEquals("Read timed out")) {
                System.out.println(e.getMessage());
            }
        }
        finally {
            response.body().close();
        }
        formattedResponse = !((String)responseBody).equals("") ? "0\r\n\r\n" : (String)formattedResponse + "\r\n0\r\n\r\n";
        return formattedResponse;
    }
}

