/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.apache.qpid.server.binding.BindingImpl;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.BindingMessages;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.logging.messages.SenderMessages;
import org.apache.qpid.server.logging.subjects.ExchangeLogSubject;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AlternateBinding;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredDerivedMethodAttribute;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DoOnConfigThread;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.queue.CreatingLinkInfo;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.Deletable;
import org.apache.qpid.server.util.DeleteDeleteTask;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.MessageDestinationIsAlternateException;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.UnknownAlternateBindingException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExchange<T extends AbstractExchange<T>>
extends AbstractConfiguredObject<T>
implements Exchange<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExchange.class);
    private static final ThreadLocal<Map<AbstractExchange<?>, Set<String>>> CURRENT_ROUTING = new ThreadLocal();
    private static final FixedKeyMapCreator BIND_ARGUMENTS_CREATOR = new FixedKeyMapCreator("bindingKey", "destination", "arguments");
    private static final FixedKeyMapCreator UNBIND_ARGUMENTS_CREATOR = new FixedKeyMapCreator("bindingKey", "destination");
    private static final Operation PUBLISH_ACTION = Operation.PERFORM_ACTION("publish");
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final Set<DestinationReferrer> _referrers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final QueueManagingVirtualHost<?> _virtualHost;
    private final LogSubject _logSubject;
    private final AtomicLong _receivedMessageCount = new AtomicLong();
    private final AtomicLong _receivedMessageSize = new AtomicLong();
    private final AtomicLong _routedMessageCount = new AtomicLong();
    private final AtomicLong _routedMessageSize = new AtomicLong();
    private final AtomicLong _droppedMessageCount = new AtomicLong();
    private final AtomicLong _droppedMessageSize = new AtomicLong();
    private final AtomicLong _producerCount = new AtomicLong();
    private final List<Binding> _bindings = new CopyOnWriteArrayList<Binding>();
    private final ConcurrentMap<MessageSender, Integer> _linkedSenders = new ConcurrentHashMap<MessageSender, Integer>();
    private final List<Action<? super Deletable<?>>> _deleteTaskList = new CopyOnWriteArrayList();
    @ManagedAttributeField(beforeSet="preSetAlternateBinding", afterSet="postSetAlternateBinding")
    private AlternateBinding _alternateBinding;
    @ManagedAttributeField
    private Exchange.UnroutableMessageBehaviour _unroutableMessageBehaviour;
    @ManagedAttributeField
    private CreatingLinkInfo _creatingLinkInfo;
    private boolean _autoDelete;
    private volatile MessageDestination _alternateBindingDestination;

    public AbstractExchange(Map<String, Object> attributes, QueueManagingVirtualHost<?> vhost) {
        super(vhost, attributes);
        HashSet<String> providedAttributeNames = new HashSet<String>(attributes.keySet());
        providedAttributeNames.removeAll(this.getAttributeNames());
        if (!providedAttributeNames.isEmpty()) {
            throw new IllegalArgumentException("Unknown attributes provided: " + providedAttributeNames);
        }
        this._virtualHost = vhost;
        this._logSubject = new ExchangeLogSubject(this, this.getVirtualHost());
    }

    @Override
    public void onValidate() {
        super.onValidate();
        if (!this.isSystemProcess() && this.isReservedExchangeName(this.getName())) {
            throw new ReservedExchangeNameException(this.getName());
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        this.validateOrCreateAlternateBinding((Exchange)proxyForValidation, false);
        if (changedAttributes.contains("desiredState") && proxyForValidation.getDesiredState() == State.DELETED) {
            this.doChecks();
        }
    }

    private boolean isReservedExchangeName(String name) {
        return name == null || "".equals(name) || name.startsWith("amq.") || name.startsWith("qpid.");
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        if (this.getCreatingLinkInfo() != null && !this.isSystemProcess()) {
            throw new IllegalConfigurationException(String.format("Cannot specify creatingLinkInfo for exchange '%s'", this.getName()));
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.validateOrCreateAlternateBinding(this, true);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        ConfiguredDerivedMethodAttribute durableBindingsAttribute = (ConfiguredDerivedMethodAttribute)this.getModel().getTypeRegistry().getAttributeTypes(this.getTypeClass()).get("durableBindings");
        Collection bindings = (Collection)durableBindingsAttribute.convertValue(this.getActualAttributes().get("durableBindings"), this);
        if (bindings != null) {
            this._bindings.addAll(bindings);
            for (Binding b : this._bindings) {
                MessageDestination messageDestination = this.getOpenedMessageDestination(b.getDestination());
                if (messageDestination == null) continue;
                Map<String, Object> arguments = b.getArguments() == null ? Collections.emptyMap() : b.getArguments();
                try {
                    this.onBind(new BindingIdentifier(b.getBindingKey(), messageDestination), arguments);
                }
                catch (AMQInvalidArgumentException e) {
                    throw new IllegalConfigurationException("Unexpected bind argument : " + e.getMessage(), e);
                }
                messageDestination.linkAdded(this, b);
            }
        }
        if (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_CREATING_LINK_CLOSE) {
            if (this._creatingLinkInfo != null) {
                Object link = this._creatingLinkInfo.isSendingLink() ? this._virtualHost.getSendingLink(this._creatingLinkInfo.getRemoteContainerId(), this._creatingLinkInfo.getLinkName()) : this._virtualHost.getReceivingLink(this._creatingLinkInfo.getRemoteContainerId(), this._creatingLinkInfo.getLinkName());
                this.addLifetimeConstraint((Deletable<? extends Deletable>)link);
            } else {
                throw new IllegalArgumentException("Exchanges created with a lifetime policy of " + this.getLifetimePolicy() + " must be created from a AMQP 1.0 link.");
            }
        }
        if (this.getAlternateBinding() != null) {
            String alternateDestination = this.getAlternateBinding().getDestination();
            this._alternateBindingDestination = this.getOpenedMessageDestination(alternateDestination);
            if (this._alternateBindingDestination != null) {
                this._alternateBindingDestination.addReference(this);
            } else {
                LOGGER.warn("Cannot find alternate binding destination '{}' for exchange '{}'", (Object)alternateDestination, (Object)this.toString());
            }
        }
    }

    @Override
    public EventLogger getEventLogger() {
        return this._virtualHost.getEventLogger();
    }

    private void performDeleteTasks() {
        for (Action<Deletable<?>> task : this._deleteTaskList) {
            task.performAction(null);
        }
        this._deleteTaskList.clear();
    }

    @Override
    public boolean isAutoDelete() {
        return this.getLifetimePolicy() != LifetimePolicy.PERMANENT;
    }

    private void addLifetimeConstraint(Deletable<? extends Deletable> lifetimeObject) {
        Action<Deletable> deleteExchangeTask = object -> Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
            this.delete();
            return null;
        });
        lifetimeObject.addDeleteTask(deleteExchangeTask);
        this._deleteTaskList.add(new DeleteDeleteTask(lifetimeObject, deleteExchangeTask));
    }

    private void performDelete() {
        if (this._closed.compareAndSet(false, true)) {
            this.performDeleteTasks();
            for (Binding b : this._bindings) {
                MessageDestination messageDestination = this.getAttainedMessageDestination(b.getDestination());
                if (messageDestination == null) continue;
                messageDestination.linkRemoved(this, b);
            }
            for (MessageSender sender : this._linkedSenders.keySet()) {
                sender.destinationRemoved(this);
            }
            if (this._alternateBindingDestination != null) {
                this._alternateBindingDestination.removeReference(this);
            }
        }
    }

    private void doChecks() {
        if (this.hasReferrers()) {
            throw new MessageDestinationIsAlternateException(this.getName());
        }
        if (this.isReservedExchangeName(this.getName())) {
            throw new RequiredExchangeException(this.getName());
        }
    }

    @Override
    @DoOnConfigThread
    public void destinationRemoved(@Param(name="destination") MessageDestination destination) {
        for (Binding b : this._bindings) {
            if (!b.getDestination().equals(destination.getName())) continue;
            Map<String, Object> bindArguments = UNBIND_ARGUMENTS_CREATOR.createMap(b.getBindingKey(), destination);
            this.getEventLogger().message(this._logSubject, BindingMessages.DELETED(String.valueOf(bindArguments)));
            this.onUnbind(new BindingIdentifier(b.getBindingKey(), destination));
            this._bindings.remove(b);
        }
        if (!this.autoDeleteIfNecessary() && destination.isDurable() && this.isDurable()) {
            Collection<Binding> durableBindings = this.getDurableBindings();
            this.attributeSet("durableBindings", durableBindings, durableBindings);
        }
    }

    @Override
    public Exchange.UnroutableMessageBehaviour getUnroutableMessageBehaviour() {
        return this._unroutableMessageBehaviour;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public QueueManagingVirtualHost<?> getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments, Queue<?> queue) {
        if (bindingKey == null) {
            bindingKey = "";
        }
        for (Binding b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey()) || !queue.getName().equals(b.getDestination())) continue;
            return b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments);
        }
        return false;
    }

    @Override
    public boolean isBound(String bindingKey, Queue<?> queue) {
        if (bindingKey == null) {
            bindingKey = "";
        }
        for (Binding b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey()) || !queue.getName().equals(b.getDestination())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(String bindingKey) {
        if (bindingKey == null) {
            bindingKey = "";
        }
        for (Binding b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(Queue<?> queue) {
        for (Binding b : this._bindings) {
            if (!queue.getName().equals(b.getDestination())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(Map<String, Object> arguments, Queue<?> queue) {
        for (Binding b : this._bindings) {
            if (!queue.getName().equals(b.getDestination()) || !(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(Map<String, Object> arguments) {
        for (Binding b : this._bindings) {
            if (!(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments) {
        if (bindingKey == null) {
            bindingKey = "";
        }
        for (Binding b : this._bindings) {
            if (!b.getBindingKey().equals(bindingKey) || !(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    @Override
    public AlternateBinding getAlternateBinding() {
        return this._alternateBinding;
    }

    private void preSetAlternateBinding() {
        if (this._alternateBindingDestination != null) {
            this._alternateBindingDestination.removeReference(this);
        }
    }

    private void postSetAlternateBinding() {
        if (this._alternateBinding != null) {
            this._alternateBindingDestination = this.getOpenedMessageDestination(this._alternateBinding.getDestination());
            if (this._alternateBindingDestination != null) {
                this._alternateBindingDestination.addReference(this);
            }
        }
    }

    @Override
    public MessageDestination getAlternateBindingDestination() {
        return this._alternateBindingDestination;
    }

    @Override
    public void removeReference(DestinationReferrer destinationReferrer) {
        this._referrers.remove(destinationReferrer);
    }

    @Override
    public void addReference(DestinationReferrer destinationReferrer) {
        this._referrers.add(destinationReferrer);
    }

    private boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    @Override
    public Collection<Binding> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    protected abstract void onBindingUpdated(BindingIdentifier var1, Map<String, Object> var2) throws AMQInvalidArgumentException;

    protected abstract void onBind(BindingIdentifier var1, Map<String, Object> var2) throws AMQInvalidArgumentException;

    protected abstract void onUnbind(BindingIdentifier var1);

    @Override
    public long getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public long getProducerCount() {
        return this._producerCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
        if (this._virtualHost.getState() != State.ACTIVE) {
            throw new VirtualHostUnavailableException(this._virtualHost);
        }
        RoutingResult<M> routingResult = new RoutingResult<M>(message);
        Map<AbstractExchange<?>, Set<String>> currentThreadMap = CURRENT_ROUTING.get();
        boolean topLevel = currentThreadMap == null;
        try {
            MessageDestination alternateBindingDestination;
            Set<String> existingRoutes;
            if (topLevel) {
                currentThreadMap = new HashMap();
                CURRENT_ROUTING.set(currentThreadMap);
            }
            if ((existingRoutes = currentThreadMap.get(this)) == null) {
                currentThreadMap.put(this, Collections.singleton(routingAddress));
            } else {
                if (existingRoutes.contains(routingAddress)) {
                    RoutingResult<M> routingResult2 = routingResult;
                    return routingResult2;
                }
                existingRoutes = new HashSet<String>(existingRoutes);
                existingRoutes.add(routingAddress);
                currentThreadMap.put(this, existingRoutes);
            }
            this._receivedMessageCount.incrementAndGet();
            long sizeIncludingHeader = message.getSizeIncludingHeader();
            this._receivedMessageSize.addAndGet(sizeIncludingHeader);
            this.doRoute(message, routingAddress, instanceProperties, routingResult);
            if (!routingResult.hasRoutes() && (alternateBindingDestination = this.getAlternateBindingDestination()) != null) {
                routingResult.add(alternateBindingDestination.route(message, routingAddress, instanceProperties));
            }
            if (routingResult.hasRoutes()) {
                this._routedMessageCount.incrementAndGet();
                this._routedMessageSize.addAndGet(sizeIncludingHeader);
            } else {
                this._droppedMessageCount.incrementAndGet();
                this._droppedMessageSize.addAndGet(sizeIncludingHeader);
            }
            RoutingResult<M> routingResult3 = routingResult;
            return routingResult3;
        }
        finally {
            if (topLevel) {
                CURRENT_ROUTING.set(null);
            }
        }
    }

    protected abstract <M extends ServerMessage<? extends StorableMessageMetaData>> void doRoute(M var1, String var2, InstanceProperties var3, RoutingResult<M> var4);

    @Override
    public boolean bind(String destination, String bindingKey, Map<String, Object> arguments, boolean replaceExistingArguments) {
        try {
            return this.bindInternal(destination, bindingKey, arguments, replaceExistingArguments);
        }
        catch (AMQInvalidArgumentException e) {
            throw new IllegalArgumentException("Unexpected bind argument : " + e.getMessage(), e);
        }
    }

    private boolean bindInternal(String destination, String bindingKey, Map<String, Object> arguments, boolean replaceExistingArguments) throws AMQInvalidArgumentException {
        MessageDestination messageDestination = this.getAttainedMessageDestination(destination);
        if (messageDestination == null) {
            throw new IllegalArgumentException(String.format("Destination '%s' is not found.", destination));
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        BindingImpl newBinding = new BindingImpl(bindingKey, destination, arguments);
        Binding previousBinding = null;
        for (Binding b : this._bindings) {
            if (!b.getBindingKey().equals(bindingKey) || !b.getDestination().equals(messageDestination.getName())) continue;
            previousBinding = b;
            break;
        }
        if (previousBinding != null && !replaceExistingArguments) {
            return false;
        }
        BindingIdentifier bindingIdentifier = new BindingIdentifier(bindingKey, messageDestination);
        if (previousBinding != null) {
            this.onBindingUpdated(bindingIdentifier, arguments);
        } else {
            Map<String, Object> bindArguments = BIND_ARGUMENTS_CREATOR.createMap(bindingKey, destination, arguments);
            this.getEventLogger().message(this._logSubject, BindingMessages.CREATED(String.valueOf(bindArguments)));
            this.onBind(bindingIdentifier, arguments);
            messageDestination.linkAdded(this, newBinding);
        }
        if (previousBinding != null) {
            this._bindings.remove(previousBinding);
        }
        this._bindings.add(newBinding);
        if (this.isDurable() && messageDestination.isDurable()) {
            Collection<Binding> durableBindings = this.getDurableBindings();
            this.attributeSet("durableBindings", durableBindings, durableBindings);
        }
        return true;
    }

    @Override
    public Collection<Binding> getPublishingLinks(MessageDestination destination) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        String destinationName = destination.getName();
        for (Binding b : this._bindings) {
            if (!b.getDestination().equals(destinationName)) continue;
            bindings.add(b);
        }
        return bindings;
    }

    @Override
    public Collection<Binding> getDurableBindings() {
        List<Binding> durableBindings;
        if (this.isDurable()) {
            durableBindings = new ArrayList();
            for (Binding b : this._bindings) {
                MessageDestination destination = this.getAttainedMessageDestination(b.getDestination());
                if (destination == null || !destination.isDurable()) continue;
                durableBindings.add(b);
            }
        } else {
            durableBindings = Collections.emptyList();
        }
        return durableBindings;
    }

    @Override
    public CreatingLinkInfo getCreatingLinkInfo() {
        return this._creatingLinkInfo;
    }

    private MessageDestination getAttainedMessageDestination(String name) {
        Queue<?> destination = this.getVirtualHost().getAttainedQueue(name);
        return destination == null ? this.getVirtualHost().getAttainedMessageDestination(name, false) : destination;
    }

    private MessageDestination getOpenedMessageDestination(String name) {
        MessageDestination destination = this.getVirtualHost().getSystemDestination(name);
        if (destination == null) {
            destination = this.getVirtualHost().getChildByName(Exchange.class, name);
        }
        if (destination == null || Objects.equals(this, destination)) {
            destination = this.getVirtualHost().getChildByName(Queue.class, name);
        }
        return destination;
    }

    @Override
    public boolean unbind(@Param(name="destination", mandatory=true) String destination, @Param(name="bindingKey") String bindingKey) {
        MessageDestination messageDestination = this.getAttainedMessageDestination(destination);
        if (messageDestination != null) {
            for (Binding binding : this._bindings) {
                if (!binding.getBindingKey().equals(bindingKey) || !binding.getDestination().equals(destination)) continue;
                this._bindings.remove(binding);
                messageDestination.linkRemoved(this, binding);
                this.onUnbind(new BindingIdentifier(bindingKey, messageDestination));
                if (!this.autoDeleteIfNecessary() && this.isDurable() && messageDestination.isDurable()) {
                    Collection<Binding> durableBindings = this.getDurableBindings();
                    this.attributeSet("durableBindings", durableBindings, durableBindings);
                }
                Map<String, Object> bindArguments = UNBIND_ARGUMENTS_CREATOR.createMap(bindingKey, destination);
                this.getEventLogger().message(this._logSubject, BindingMessages.DELETED(String.valueOf(bindArguments)));
                return true;
            }
        }
        return false;
    }

    @Override
    public long getMessagesIn() {
        return this._receivedMessageCount.get();
    }

    public long getMsgRoutes() {
        return this._routedMessageCount.get();
    }

    @Override
    public long getMessagesDropped() {
        return this._droppedMessageCount.get();
    }

    @Override
    public long getBytesIn() {
        return this._receivedMessageSize.get();
    }

    public long getByteRoutes() {
        return this._routedMessageSize.get();
    }

    @Override
    public long getBytesDropped() {
        return this._droppedMessageSize.get();
    }

    @Override
    public boolean addBinding(String bindingKey, Queue<?> queue, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        return this.bindInternal(queue.getName(), bindingKey, arguments, false);
    }

    @Override
    public void replaceBinding(String bindingKey, Queue<?> queue, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        this.bindInternal(queue.getName(), bindingKey, arguments, true);
    }

    private boolean autoDeleteIfNecessary() {
        if (this.isAutoDeletePending()) {
            LOGGER.debug("Auto-deleting exchange: {}", (Object)this);
            this.delete();
            return true;
        }
        return false;
    }

    private boolean isAutoDeletePending() {
        return (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS || this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_NO_LINKS) && this.getBindingCount() == 0L;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        if (this.getState() != State.UNINITIALIZED) {
            this.performDelete();
        }
        this.preSetAlternateBinding();
        return super.onDelete();
    }

    @Override
    public boolean deleteBinding(String bindingKey, Queue<?> queue) {
        return this.unbind(queue.getName(), bindingKey);
    }

    @Override
    public boolean hasBinding(String bindingKey, Queue<?> queue) {
        if (bindingKey == null) {
            bindingKey = "";
        }
        for (Binding b : this._bindings) {
            if (!b.getBindingKey().equals(bindingKey) || !b.getDestination().equals(queue.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._virtualHost;
    }

    @Override
    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        this.authorise(token, PUBLISH_ACTION, arguments);
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(ExchangeMessages.OPERATION(operation));
    }

    @Override
    public void linkAdded(MessageSender sender, PublishingLink link) {
        Integer oldValue = this._linkedSenders.putIfAbsent(sender, 1);
        if (oldValue != null) {
            this._linkedSenders.put(sender, oldValue + 1);
        }
        if ("link".equals(link.getType())) {
            this._producerCount.incrementAndGet();
            this.getEventLogger().message(SenderMessages.CREATE(link.getName(), link.getDestination()));
        }
    }

    @Override
    public void linkRemoved(MessageSender sender, PublishingLink link) {
        int oldValue = (Integer)this._linkedSenders.remove(sender);
        if (oldValue != 1) {
            this._linkedSenders.put(sender, oldValue - 1);
        }
        if ("link".equals(link.getType())) {
            this._producerCount.decrementAndGet();
            this.getEventLogger().message(SenderMessages.CLOSE(link.getName(), link.getDestination()));
        }
    }

    @Override
    public void close() {
        this._producerCount.set(0L);
        super.close();
    }

    private void validateOrCreateAlternateBinding(Exchange<?> exchange, boolean mayCreate) {
        Object value = exchange.getAttribute("alternateBinding");
        if (value instanceof AlternateBinding) {
            AlternateBinding alternateBinding = (AlternateBinding)value;
            String destinationName = alternateBinding.getDestination();
            MessageDestination messageDestination = this._virtualHost.getAttainedMessageDestination(destinationName, mayCreate);
            if (messageDestination == null) {
                throw new UnknownAlternateBindingException(destinationName);
            }
            if (messageDestination == this) {
                throw new IllegalConfigurationException(String.format("Cannot create alternate binding for '%s' : Alternate binding destination cannot refer to self.", this.getName()));
            }
            if (this.isDurable() && !messageDestination.isDurable()) {
                throw new IllegalConfigurationException(String.format("Cannot create alternate binding for '%s' : Alternate binding destination '%s' is not durable.", this.getName(), destinationName));
            }
        }
    }

    @Override
    public void resetStatistics() {
        this._receivedMessageCount.set(0L);
        this._receivedMessageSize.set(0L);
        this._routedMessageCount.set(0L);
        this._routedMessageSize.set(0L);
        this._droppedMessageCount.set(0L);
        this._droppedMessageSize.set(0L);
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(this._logSubject, ExchangeMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this.getEventLogger().message(this._logSubject, ExchangeMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this.getEventLogger().message(this._logSubject, ExchangeMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(this._logSubject, ExchangeMessages.UPDATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    public static final class BindingIdentifier {
        private final String _bindingKey;
        private final MessageDestination _destination;

        public BindingIdentifier(String bindingKey, MessageDestination destination) {
            this._bindingKey = bindingKey;
            this._destination = destination;
        }

        public String getBindingKey() {
            return this._bindingKey;
        }

        public MessageDestination getDestination() {
            return this._destination;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingIdentifier that = (BindingIdentifier)o;
            return this._bindingKey.equals(that._bindingKey) && this._destination.equals(that._destination);
        }

        public int hashCode() {
            int result = this._bindingKey.hashCode();
            result = 31 * result + this._destination.hashCode();
            return result;
        }
    }
}

