/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.exchange.HeadersExchangeImpl;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

final class HeadersExchangeImplWithAccessChecking
extends HeadersExchangeImpl {
    private static final FixedKeyMapCreator BIND_MAP_CREATOR = new FixedKeyMapCreator("destination", "bindingKey", "arguments", "replaceExistingArguments");
    private static final FixedKeyMapCreator UNBIND_MAP_CREATOR = new FixedKeyMapCreator("destination", "bindingKey");

    HeadersExchangeImplWithAccessChecking(Map<String, Object> attributes, QueueManagingVirtualHost<?> queuemanagingvirtualhost) {
        super(attributes, queuemanagingvirtualhost);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean bind(final String destination, final String bindingKey, final Map<String, Object> arguments, final boolean replaceExistingArguments) {
        this.authorise(Operation.INVOKE_METHOD("bind"), BIND_MAP_CREATOR.createMap(destination, bindingKey, arguments, replaceExistingArguments));
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.bind(destination, bindingKey, arguments, replaceExistingArguments));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "bind";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "destination=" + destination + ",bindingKey=" + bindingKey + ",arguments=" + arguments + ",replaceExistingArguments=" + replaceExistingArguments;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean unbind(final String destination, final String bindingKey) {
        this.authorise(Operation.INVOKE_METHOD("unbind"), UNBIND_MAP_CREATOR.createMap(destination, bindingKey));
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.unbind(destination, bindingKey));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "unbind";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "destination=" + destination + ",bindingKey=" + bindingKey;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD("resetStatistics"));
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                HeadersExchangeImplWithAccessChecking.super.resetStatistics();
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "resetStatistics";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public boolean addBinding(final String bindingKey, final Queue<?> queue, final Map<String, Object> arguments) throws AMQInvalidArgumentException {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                try {
                    return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.addBinding(bindingKey, queue, arguments));
                }
                catch (AMQInvalidArgumentException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "addBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + queue + ",arguments=" + arguments;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean deleteBinding(final String bindingKey, final Queue<?> queue) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.deleteBinding(bindingKey, queue));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "deleteBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + queue;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean hasBinding(final String bindingKey, final Queue<?> queue) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.hasBinding(bindingKey, queue));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "hasBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + queue;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void replaceBinding(final String bindingKey, final Queue<?> queue, final Map<String, Object> arguments) throws AMQInvalidArgumentException {
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                try {
                    HeadersExchangeImplWithAccessChecking.super.replaceBinding(bindingKey, queue, arguments);
                    return Futures.immediateFuture(null);
                }
                catch (AMQInvalidArgumentException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "replaceBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + queue + ",arguments=" + arguments;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean isBound(final String bindingKey, final Map<String, Object> arguments, final Queue<?> queue) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.isBound(bindingKey, arguments, queue));
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "isBound";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",arguments=" + arguments + ",queue=" + queue;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean hasBindings() {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Boolean> execute() {
                return Futures.immediateFuture((Object)HeadersExchangeImplWithAccessChecking.super.hasBindings());
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "hasBindings";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public void destinationRemoved(final MessageDestination destination) {
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                HeadersExchangeImplWithAccessChecking.super.destinationRemoved(destination);
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return HeadersExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "destinationRemoved";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "destination=" + destination;
                }
                return this._args;
            }
        }));
    }
}

