/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class ConnectionMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String CONNECTION_LOG_HIERARCHY = "qpid.message.connection";
    public static final String CLIENT_VERSION_LOG_LOG_HIERARCHY = "qpid.message.connection.client_version_log";
    public static final String CLIENT_VERSION_REJECT_LOG_HIERARCHY = "qpid.message.connection.client_version_reject";
    public static final String CLOSE_LOG_HIERARCHY = "qpid.message.connection.close";
    public static final String DROPPED_CONNECTION_LOG_HIERARCHY = "qpid.message.connection.dropped_connection";
    public static final String IDLE_CLOSE_LOG_HIERARCHY = "qpid.message.connection.idle_close";
    public static final String IDLE_TXN_LOG_HIERARCHY = "qpid.message.connection.idle_txn";
    public static final String LARGE_TRANSACTION_WARN_LOG_HIERARCHY = "qpid.message.connection.large_transaction_warn";
    public static final String MODEL_DELETE_LOG_HIERARCHY = "qpid.message.connection.model_delete";
    public static final String OPEN_LOG_HIERARCHY = "qpid.message.connection.open";
    public static final String OPEN_TXN_LOG_HIERARCHY = "qpid.message.connection.open_txn";
    public static final String OPERATION_LOG_HIERARCHY = "qpid.message.connection.operation";

    public static LogMessage CLIENT_VERSION_LOG(String param1) {
        String rawMessage = MESSAGES.getString("CLIENT_VERSION_LOG");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.CLIENT_VERSION_LOG_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CLIENT_VERSION_REJECT(String param1) {
        String rawMessage = MESSAGES.getString("CLIENT_VERSION_REJECT");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.CLIENT_VERSION_REJECT_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CLOSE(String param1, boolean opt1) {
        String rawMessage = MESSAGES.getString("CLOSE");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
        }
        rawMessage = msg.toString();
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.CLOSE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage DROPPED_CONNECTION() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("DROPPED_CONNECTION");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.DROPPED_CONNECTION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage IDLE_CLOSE(String param1, boolean opt1) {
        String rawMessage = MESSAGES.getString("IDLE_CLOSE");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
        }
        rawMessage = msg.toString();
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.IDLE_CLOSE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage IDLE_TXN(Number param1) {
        String rawMessage = MESSAGES.getString("IDLE_TXN");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.IDLE_TXN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage LARGE_TRANSACTION_WARN(Number param1, Number param2) {
        String rawMessage = MESSAGES.getString("LARGE_TRANSACTION_WARN");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.LARGE_TRANSACTION_WARN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage MODEL_DELETE() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("MODEL_DELETE");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.MODEL_DELETE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPEN(String param1, String param2, String param3, String param4, String param5, String param6, boolean opt1, boolean opt2, boolean opt3, boolean opt4) {
        String rawMessage = MESSAGES.getString("OPEN");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
            end = parts[2].indexOf(93);
            if (opt2) {
                msg.append(parts[2].substring(0, end));
            }
            msg.append(parts[2].substring(end + 1));
            end = parts[3].indexOf(93);
            if (opt3) {
                msg.append(parts[3].substring(0, end));
            }
            msg.append(parts[3].substring(end + 1));
            end = parts[4].indexOf(93);
            if (opt4) {
                msg.append(parts[4].substring(0, end));
            }
            msg.append(parts[4].substring(end + 1));
        }
        rawMessage = msg.toString();
        Object[] messageArguments = new Object[]{param1, param2, param3, param4, param5, param6};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.OPEN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPEN_TXN(Number param1) {
        String rawMessage = MESSAGES.getString("OPEN_TXN");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.OPEN_TXN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPERATION(String param1) {
        String rawMessage = MESSAGES.getString("OPERATION");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ConnectionMessages.OPERATION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private ConnectionMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)CONNECTION_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLIENT_VERSION_LOG_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLIENT_VERSION_REJECT_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLOSE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)DROPPED_CONNECTION_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)IDLE_CLOSE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)IDLE_TXN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)LARGE_TRANSACTION_WARN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)MODEL_DELETE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPEN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPEN_TXN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPERATION_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.Connection_logmessages", CURRENT_LOCALE);
    }
}

