/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.rest;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.rest.RestProviderDescriptor;
import de.iip_ecosphere.platform.support.rest.RestTarget;
import java.io.IOException;

public abstract class Rest {
    private static Rest instance = (Rest)PluginManager.getPluginInstance(Rest.class, RestProviderDescriptor.class);

    public static Rest getInstance() {
        return instance;
    }

    public static void setInstance(Rest rest) {
        if (null != rest) {
            instance = rest;
        }
    }

    public abstract RestServer createServer(int var1);

    public RestServer createServer(ServerAddress addr) {
        return this.createServer(addr.getPort());
    }

    public abstract RestTarget createTarget(String var1);

    public static interface RestServer
    extends Server {
        public void definePost(String var1, Route var2);

        public void defineGet(String var1, Route var2);

        public void definePut(String var1, Route var2);

        public void defineDelete(String var1, Route var2);

        public void defineBefore(Filter var1);

        public void defineBefore(String var1, Filter var2);

        public void halt(int var1, String var2);

        public boolean supportsPathVariables();

        public String toPathVariable(String var1);

        public void secure(String var1, String var2, String var3);

        public void addExceptionHandler(Class<Exception> var1, ExceptionHandler var2);
    }

    @FunctionalInterface
    public static interface ExceptionHandler {
        public void handle(Exception var1, Request var2, Response var3);
    }

    @FunctionalInterface
    public static interface Filter {
        public void handle(Request var1, Response var2) throws IOException;
    }

    @FunctionalInterface
    public static interface Route {
        public Object handle(Request var1, Response var2) throws IOException;
    }

    public static interface Response {
        public void setBody(String var1);

        public String getBody();

        public void setStatus(int var1);

        public void setType(String var1);

        default public void setApplicationJsonType() {
            this.setType("application/json");
        }
    }

    public static interface Request {
        public String getBody();

        public String getParam(String var1);

        public String getContentType();

        public String getQueryString();

        public String getPath();
    }
}

