/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import org.jetbrains.annotations.NotNull;

public class BindingUtils {
    private BindingUtils() {
    }

    public static short readShort(@NotNull ByteArrayInputStream stream) {
        return (short)(BindingUtils.readUnsignedShort(stream) ^ 0x8000);
    }

    public static int readInt(@NotNull ByteArrayInputStream stream) {
        return (int)(BindingUtils.readUnsignedInt(stream) ^ Integer.MIN_VALUE);
    }

    public static long readLong(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readUnsignedLong(stream) ^ Long.MIN_VALUE;
    }

    public static float readFloat(@NotNull ByteArrayInputStream stream) {
        return Float.intBitsToFloat((int)BindingUtils.readUnsignedInt(stream));
    }

    public static double readDouble(@NotNull ByteArrayInputStream stream) {
        return Double.longBitsToDouble(BindingUtils.readUnsignedLong(stream));
    }

    public static String readString(@NotNull ByteArrayInputStream stream) {
        int next = stream.read();
        if (next == 255) {
            next = stream.read();
            if (next == 0) {
                return null;
            }
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        while (next != 0) {
            int char1 = next & 0xFF;
            switch ((char1 & 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    sb.append((char)char1);
                    break;
                }
                case 12: 
                case 13: {
                    int char2 = stream.read();
                    if ((char2 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    sb.append((char)((char1 & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    int char2 = stream.read();
                    int char3 = stream.read();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    sb.append((char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            next = stream.read();
        }
        return sb.toString();
    }

    private static int readUnsignedShort(@NotNull ByteArrayInputStream stream) {
        int c2;
        int c1 = stream.read();
        if ((c1 | (c2 = stream.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 8 | c2;
    }

    private static long readUnsignedInt(@NotNull ByteArrayInputStream stream) {
        long c4;
        long c3;
        long c2;
        long c1 = stream.read();
        if ((c1 | (c2 = (long)stream.read()) | (c3 = (long)stream.read()) | (c4 = (long)stream.read())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private static long readUnsignedLong(@NotNull ByteArrayInputStream stream) {
        long c8;
        long c7;
        long c6;
        long c5;
        long c4;
        long c3;
        long c2;
        long c1 = stream.read();
        if ((c1 | (c2 = (long)stream.read()) | (c3 = (long)stream.read()) | (c4 = (long)stream.read()) | (c5 = (long)stream.read()) | (c6 = (long)stream.read()) | (c7 = (long)stream.read()) | (c8 = (long)stream.read())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 56 | c2 << 48 | c3 << 40 | c4 << 32 | c5 << 24 | c6 << 16 | c7 << 8 | c8;
    }
}

