/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Date;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalExecutable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/env/StuckTransactionMonitor;", "Ljetbrains/exodus/core/execution/Job;", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "(Ljetbrains/exodus/env/EnvironmentImpl;)V", "<set-?>", "", "stuckTxnCount", "getStuckTxnCount", "()I", "setStuckTxnCount", "(I)V", "execute", "", "queueThis", "Companion", "xodus-environment"})
public final class StuckTransactionMonitor
extends Job {
    private int stuckTxnCount;
    private final EnvironmentImpl env;
    public static final Companion Companion = new Companion(null);

    public final int getStuckTxnCount() {
        return this.stuckTxnCount;
    }

    private final void setStuckTxnCount(int n) {
        this.stuckTxnCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void execute() {
        if (this.env.isOpen()) {
            void stuckTxnCount;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            try {
                int transactionTimeout = this.env.transactionTimeout();
                if (transactionTimeout != 0) {
                    long creationTimeBound = System.currentTimeMillis() - (long)transactionTimeout;
                    this.env.forEachActiveTransaction(new TransactionalExecutable(creationTimeBound, (Ref.IntRef)stuckTxnCount){
                        final /* synthetic */ long $creationTimeBound;
                        final /* synthetic */ Ref.IntRef $stuckTxnCount;

                        public final void execute(@NotNull Transaction it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            TransactionBase txn = (TransactionBase)it;
                            Throwable trace = txn.getTrace();
                            long created = txn.getStartTime();
                            if (trace != null && created < this.$creationTimeBound) {
                                Thread creatingThread = txn.getCreatingThread();
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                PrintStream ps = new PrintStream(out);
                                StringBuilder stringBuilder = new StringBuilder().append("Transaction timed out: created at ").append(new Date(created)).append(", thread = ").append(creatingThread).append('(');
                                Thread thread = creatingThread;
                                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"creatingThread");
                                String errorHeader = stringBuilder.append(thread.getId()).append(')').toString();
                                OutputStream outputStream = ps;
                                Charset charset = Charsets.UTF_8;
                                new OutputStreamWriter(outputStream, charset).write(errorHeader);
                                trace.printStackTrace(ps);
                                StuckTransactionMonitor.Companion.getLogger().error(errorHeader, trace);
                                Ref.IntRef intRef = this.$stuckTxnCount;
                                ++intRef.element;
                                int cfr_ignored_0 = intRef.element;
                            }
                        }
                        {
                            this.$creationTimeBound = l;
                            this.$stuckTxnCount = intRef;
                        }
                    });
                }
            }
            finally {
                this.stuckTxnCount = stuckTxnCount.element;
                this.queueThis();
            }
        }
    }

    private final void queueThis() {
        JobProcessor jobProcessor = this.getProcessor();
        Job job = this;
        EnvironmentConfig environmentConfig = this.env.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"env.environmentConfig");
        jobProcessor.queueIn(job, (long)environmentConfig.getEnvMonitorTxnsCheckFreq());
    }

    public StuckTransactionMonitor(@NotNull EnvironmentImpl env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        this.env = env;
        this.setProcessor((JobProcessor)ThreadJobProcessorPool.getOrCreateJobProcessor((String)"Exodus shared stuck transaction monitor"));
        this.queueThis();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/env/StuckTransactionMonitor$Companion;", "Lmu/KLogging;", "()V", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

