/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;

public class DataCorruptionException
extends ExodusException {
    DataCorruptionException(@NotNull String message) {
        super(message);
    }

    private DataCorruptionException(@NotNull String message, long address, long fileLengthBound) {
        this(message + LogUtil.getWrongAddressErrorMessage(address, fileLengthBound));
    }

    static void raise(@NotNull String message, @NotNull Log log, long address) {
        DataCorruptionException.checkLogIsClosing(log);
        throw new DataCorruptionException(message, address, log.getFileLengthBound());
    }

    static void checkLogIsClosing(@NotNull Log log) {
        if (log.isClosing()) {
            throw new IllegalStateException("Attempt to read closed log");
        }
    }
}

